package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.CreateProblemDo;
import com.ovopark.check.Vo.DetectScoreVO;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author ：Bruce
 * @description：店探api
 * @date ：2021/9/26 15:46
 */
@FeignClient(value = "shopweb-check")
public interface DetectApi {

    @PostMapping("/shopweb-check/detect/saveScore")
    BaseResult saveScore(@RequestBody DetectScoreVO detectScoreVO);

    @PostMapping("/shopweb-check/problem/saveToProblemDt")
    R saveToProblemDt(@RequestBody CreateProblemDo createProblemDo);

    @PostMapping("/shopweb-check/detect/delDetect")
    R delDetect(@RequestParam("historyId") Integer historyId,@RequestParam("enterpriseId")  Integer enterpriseId);

    @PostMapping("/shopweb-check/detect/rollbackDetect")
    R rollbackDetect(@RequestParam("historyId") Integer historyId,@RequestParam("enterpriseId")  Integer enterpriseId);

    @GetMapping("/shopweb-check/detect/isFinished")
    BaseResult<Boolean> isFinished(@RequestParam("historyId") Integer historyId,@RequestParam("problemClassifyId")  Integer problemClassifyId);
}
