package com.ovopark.check.problem;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Data
public class Option {

    //选择题类型:    0单选，1多选 2常规题
    private Integer choiceQuestionType;
    // 总得分 （常规提探店需要传）
    private BigDecimal mark;
    // 总标准分 （常规提探店需要传）
    private BigDecimal totalMark;
    // 选择题整改人 审批人 都可以编辑（前提是当前处理人）
    // 常规题  审批人 都可以编辑（前提是当前处理人）
    private boolean editable = false;
    //选择题列表
    private List<Subject> subject;
    //常规题得分类型  0 非自定义 ， 1 自定义
    private Integer scoreType;
    //常规题自定义得分列表
    private List<BigDecimal> customMark;
    //常规题步长  1, 0.25
    private BigDecimal step;

    public BigDecimal getMark() {
        // 常规题
        if(isCommonQuestion()) return mark;
        // 选择题
        if(CollectionUtils.isEmpty(subject))    return BigDecimal.ZERO;
        List<String> selected = subject.stream().filter(Subject::isChoiceStatus).map(Subject::getChoiceQuestionMark).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(selected))   return BigDecimal.ZERO;
        return selected.stream().map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalMark() {
        // 常规题返回总标准分
        if(isCommonQuestion())  return totalMark;
        //单选题 分数最高那个选项才是总分，多选题 所有分数加起来才是总分
        if(CollectionUtils.isEmpty(subject))    return BigDecimal.ZERO;
        if(choiceQuestionType == 0){
            return subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        }else{
            return subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
    }

    public boolean isChoiceQuestion(){
        return Objects.equals(choiceQuestionType,0) || Objects.equals(choiceQuestionType,1);
    }

    public boolean isCommonQuestion(){
        return Objects.equals(choiceQuestionType,2);
    }

    public boolean isCustomScoreType() {
        return Objects.equals(scoreType,1);
    }

    //后端处理就放开这段代码，目前是前端计算
//    public List<BigDecimal> getCustomMark() {
//        if (scoreType == null) {
//            return new ArrayList<>();
//        }
//        if(isCustomScoreType()){
//            return customMark;
//        }else{
//            //0-totalMark 范围内 步长为step
//            if(totalMark == null || step == null) return new ArrayList<>();
//            List<BigDecimal> customMark = new ArrayList<>();
//            for (BigDecimal i = BigDecimal.ZERO; i.compareTo(totalMark) <= 0; i = i.add(step)) {
//                customMark.add(i);
//            }
//            return customMark;
//        }
//    }
}
