package com.ovopark.check;

import org.slf4j.MDC;

/**
 * 注意！！！
 * 统一写到com.ovopark.check.pojo.R类中，防止code、message重复
 * @param <T>
 */
@Deprecated
public class R<T> {

	// 通用的状态码
	public abstract static class CommonCode {
		public static final String SUCCESS = "0"; // 获取数据成功状态码
		public static final String ERROR = "1";    //	请求失败

		public static final String IS_EXIST = "10000"; // 数据已存在
		public static final String INVALID_TOKEN = "20000"; // token有误
		public static final String PARAM_ERROR = "20001"; // 参数传递错误状态码
		public static final String NO_DATA = "20002"; //没有数据
		public static final String RESULT_DUPLICATE = "20003";//重复提交
		public static final String DELETE_FAILE = "20004";//删除失败
		public static final String POINT_EXCEED_LIMIT = "20005"; //预置位已用完
		public static final String NO_PRIVILEGE = "20006"; //没有权限
		public static final String NO_SUPPORT = "20007"; //不支持
		public static final String TEMPLATE_DUPLICATE = "20008";
		public static final String TIME_OVER_ERROR = "50001"; // 任务时间无效
		public static final String REPEAT_INTERVAL_ERROR = "50002"; // 执行间隔不能超过24h
		public static final String NO_SUMMARY = "20009";  //没有总结
		public static final String NO_REMARK = "20010"; //没有评论
		public static final String PROCESS_EXPIRED = "20011"; //申诉流程已结束

		public static final String PARAM_VALID_ERROR = "80001"; //参数格式校验失败
		public static final String CREATE_LIVE_TASK_ERROR = "90001"; //创建巡店任务失败
		public static final String EXIST_CHECK_TASK = "90002"; //点检项下面存在点检任务 删除失败
		public static final String DB_SHOP_VIEW = "90003"; // 点检项配置有效期大于企业配置的有效期,默认拿企业配置的有效期
		public static final String NO_CARBONCOPYRECIPIENTS = "81001"; //巡店提交没有抄送人
		public static final String ROLE_CHECKER_REFORMER_REPEAT = "81002"; //整改人与复检人角色重复
		public static final String ROLE_CHECKER_REFORMER_NOT_EXIST = "81003"; //复检人角色或者抄送人角色不存在
		public static final String DEPT_EXPIRE = "81004"; //门店已过期
		public static final String NO_ENTERPRISECONFIG_FOR_CHECKINFORMATIONREPORT = "81005"; // 个性化配置-门店报备未配置
		public static final String NO_USER_WAS_GRANT_FOR_CHECKINFORMATIONREPORT = "81006"; // 此角色下有此门店权限的人不存在
		public static final String DEPARTMENT_NOT_EXIST = "81007"; // 门店不存在
		public static final String COMMENTS_OF_COMMENTS_CANNOT_BE_COMMENTED = "81008"; // 评论的评论不能进行评论
		public static final String COMMENT_CANNOT_BE_NULL = "81009"; // 评论不能为空
	}

	// 通用的消息
	public abstract static class CommonMessage {
		public static final String SUCCESS = "SUCCESS"; // 获取数据成功
		public static final String ERROR = "ERROR";    //	请求失败
		public static final String IS_EXIST = "IS_EXIST";
		public static final String INVALID_TOKEN = "INVALID_TOKEN"; // token有误
		public static final String PARAM_ERROR = "PARAM_ERROR"; // 参数传递错误
		public static final String DELETE_FAILE = "DELETE_FAILE";
		public static final String TIME_OVER_ERROR = "TIME_OVER_ERROR"; // 任务永远不会被执行
		public static final String REPEAT_INTERVAL_ERROR = "can not exceed 24 hours"; // 执行间隔不能超过24h
		public static final String RESULT_NO_DATA = "NO_DATA";
		public static final String RESULT_DUPLICATE = "DUPLICATE";
		public static final String RESULT_RULE_DUPLICATE = "RESULT_RULE_DUPLICATE";
		public static final String NO_PRIVILEGE = "NO_PRIVILEGE";
		public static final String NO_SUPPORT = "NO_SUPPORT";
		public static final String TEMPLATE_DUPLICATE = "模板类型不统一";
		//预置位已用完
		public static final String POINT_EXCEED_LIMIT = "EXCEED_LIMIT";

		public static final String PARAM_VALID_ERROR = "参数格式校验失败";

		public static final String NO_SUMMARY = "NO_SUMMARY";
		public static final String NO_REMARK = "NO_REMARK";

		public static final String CREATE_LIVE_TASK_ERROR = "CREATE_LIVE_TASK_ERROR"; //创建巡店任务失败

		public static final String EXIST_CHECK_TASK = "EXIST_CHECK_TASK"; //点检项下面存在点检任务 删除失败
		public static final String NO_CARBONCOPYRECIPIENTS = "NO_CARBONCOPYRECIPIENTS"; //巡店提交没有抄送人
		public static final String ROLE_CHECKER_REFORMER_REPEAT = "ROLE_CHECKER_REFORMER_REPEAT"; //整改人与复检人角色重复
		public static final String ROLE_CHECKER_REFORMER_NOT_EXIST = "ROLE_CHECKER_REFORMER_NOT_EXIST"; //复检人角色或者抄送人角色不存在
		public static final String DEPT_EXPIRE = "DEPARTMENT_EXPIRE"; //门店已过期
		public static final String NO_ENTERPRISECONFIG_FOR_CHECKINFORMATIONREPORT = "no EnterpriseConfig for CheckInformationReport"; // 个性化配置-门店报备未配置
		public static final String NO_USER_WAS_GRANT_FOR_CHECKINFORMATIONREPORT = "no user was grant for CheckInformationReport"; // 此角色下有此门店权限的人不存在
		public static final String DEPARTMENT_NOT_EXIST = "department not exist"; // 门店不存在
		public static final String COMMENTS_OF_COMMENTS_CANNOT_BE_COMMENTED = "comments of comments cannot be commented"; // 评论的评论不能进行评论
		public static final String COMMENT_CANNOT_BE_NULL = "comment cannot be null"; // 评论不能为空
		public static final String URL_IS_NULL = "URL_IS_NULL"; //图

	}


	public R() {
	}

	private Boolean isError;
	private T data;
	private String code;
	private String message;
	private String requestId;

	public Boolean getIsError() {
		return isError;
	}

	public void setIsError(Boolean isError) {
		this.isError = isError;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public R(Boolean isError, T data, String code, String message) {
		this.isError = isError;
		this.data = data;
		this.code = code;
		this.message = message;
	}

	public static <T> R<T> getInstance(Boolean isError, T data, String code, String message) {
		return new R<T>(isError, data, code, message);
	}

	public static <T> R<T> invalidToken() {
		return getInstance(true, null, CommonCode.INVALID_TOKEN, CommonMessage.INVALID_TOKEN);
	}

	public static <T> R<T> paramError() {
		return getInstance(true, null, CommonCode.PARAM_ERROR, CommonMessage.PARAM_ERROR);
	}

	public static <T> R<T> noData() {
		return getInstance(false, null, CommonCode.NO_DATA, CommonMessage.RESULT_NO_DATA);
	}

	public static <T> R<T> duplicate() {
		return getInstance(true, null, CommonCode.RESULT_DUPLICATE, CommonMessage.RESULT_DUPLICATE);
	}

	public static <T> R<T> success() {
		return getInstance(false, null, CommonCode.SUCCESS, CommonMessage.SUCCESS);
	}

	public static <T> R<T> success(T data) {
		return getInstance(false, data, CommonCode.SUCCESS, CommonMessage.SUCCESS);
	}

	public static <T> R<T> success(String code, String message, T data) {
		return getInstance(false, data, code, message);
	}

	public static <T> R<T> error() {
		return getInstance(true, null, CommonCode.ERROR, CommonMessage.ERROR);
	}

	public static <T> R<T> error(String code, String message) {
		return getInstance(true, null, code, message);
	}

	@Deprecated
	public static <T> R<T> error(T data) {
		return getInstance(true, data, CommonCode.ERROR, CommonMessage.ERROR);
	}

	public static <T> R<T> error(String code, String message, T data) {
		return getInstance(true, data, code, message);
	}

	public String getRequestId() {
		return MDC.get("TRACE_ID");
	}

}
