package com.ovopark.check.core;

import com.ovopark.check.common.Command;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 潘思凡
 * @since 2022/4/9 1:44 下午
 */
@Data
@Accessors(chain = true)
@ToString
public class CreateCheckTaskCmd extends Command {

    private Integer templateId;
    private Integer depId;
    //0.
    private Integer checkType;
    private Integer source;
    private String address;
    private Integer storePlanDetailId;
    //
    private Integer checkPlanTaskId;
    //是巡检任务 why flag?
    private Boolean flag;
    //是否删除旧的未完成的任务
    private Boolean deleteOldTask;
    private List<Long> checkInPicIds;
    private Integer isCreateInRange;


    // 创建巡店任务、门店自检时的手机标识码
    private String uuid;
    // 经度
    private Double longitude;
    // 纬度
    private Double latitude;
    // 超出范围(单位米，isCreateInRange=0有值)
    private Double distance;
    private String netType;
    private Double battery;
}
