package com.ovopark.api;

import com.ovopark.check.R;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "shopweb-check")
public interface CheckTemplateApi {
    /**
     * 根据用户id获取用户有权限的模板列表
     * @param enterpriseId 企业id
     * @param userId 用户id
     * @return
     */
    @PostMapping("/shopweb-check/checkTemplate/getPrivilegedTemplateList")
    R<List<Integer>> getPrivilegedTemplateList(@RequestParam("enterpriseId") Integer enterpriseId, @RequestParam("userId") Integer userId);
}
