package com.ovopark.api;

import com.ovopark.check.vos.CheckRankingReportSearchInfo;

import com.ovopark.check.R;
import com.ovopark.check.vos.DistributionRankingVo;
import com.ovopark.check.vos.IndicatorDataBo;
import com.ovopark.check.vos.PageVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@FeignClient(value = "check-report")
public interface RankReportApi {
    @PostMapping("/check-report/rank/getDepartmentRanking")
    R<PageVo<IndicatorDataBo>> getDepartmentRanking(@RequestHeader("ovo-authorization") String authorization, @RequestBody CheckRankingReportSearchInfo searchInfo);

    @PostMapping("/check-report/rank/getOrganizeDistributionRanking")
    R<DistributionRankingVo> getOrganizeDistributionRanking(@RequestHeader("ovo-authorization") String authorization, @RequestBody CheckRankingReportSearchInfo searchInfo);

    @PostMapping("/check-report/rank/getOrganizeRanking")
    R<PageVo<IndicatorDataBo>> getOrganizeRanking(@RequestHeader("ovo-authorization") String authorization, @RequestBody CheckRankingReportSearchInfo searchInfo);
}
