package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.*;
import com.ovopark.check.vos.ActivityTrackPeriodSum;
import com.ovopark.check.vos.ActivityTrackSearchInfo;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @ClassName CheckProblemsApi
 * @Description 代办单api
 * @Author yangjie
 * @Date 2021/9/23 09:58
 */
@FeignClient(value = "shopweb-check")
public interface CheckInternalOpenApi {


    @GetMapping("/shopweb-check/internalOpen/problem/getUnfinishedProblemNumByUserId")
    BaseResult<Integer> getUnfinishedProblemNumByUserId(@RequestParam("userId") Integer userId, @RequestParam("groupId") Integer groupId);

    /**
     * 获取点检项
     *
     * @param id
     * @return
     */
    @GetMapping("/shopweb-check/internalOpen/getDbViewShopById")
    R getDbViewShopById(Integer id);

    @GetMapping("/shopweb-check/internalOpen/getPresetNamesByEnterpriseId")
    R<List<Map<String, Object>>> getPresetNamesByEnterpriseId(Integer id);

    @GetMapping("/shopweb-check/internalOpen/selectTaskIds")
    R<List<Integer>> selectTaskIds(Integer id);

    @PostMapping("/shopweb-check/internalOpen/deletePresetNameParentViewShopsById")
    R deletePresetNameParentViewShopsById(Integer id);

    @PostMapping("/shopweb-check/internalOpen/savePresetNameParentViewShopsById")
    R savePresetNameParentViewShops(@RequestBody Map<String, Object> presetNameParentViewShops);


    @GetMapping("/shopweb-check/internalOpen/getSceneList")
    R<List<SceneDTO>> getSceneList(Integer deviceId);

    @PostMapping("/shopweb-check/internalOpen/updateNameBySceneModel")
    R updateNameBySceneModel(@RequestParam("sceneModel") Integer sceneModel,@RequestParam("sceneName") String sceneName);

    @RequestMapping(value = "/shopweb-check/internalOpen/getEnterpriseSceneByDeviceId")
    R<List<SceneVo>> getEnterpriseSceneByDeviceId(@RequestParam("deviceId") Integer deviceId, @RequestParam("presetNo") Integer presetNo);
    @PostMapping("/shopweb-check/internalOpen/abandonLiveCheckTask")
    R<Boolean> abandonLiveCheckTask(@RequestParam("taskId")Integer taskId);

    @PostMapping("/shopweb-check/internalOpen/listInspectionItem")
    R<List<InspectionItemVo>> listInspectionItem(@RequestBody List<Integer> ids);


    @PostMapping("/shopweb-check/internalOpen/saveOrUpdateScene")
    R saveOrUpdateScene(@RequestBody SceneVo scene);


    @RequestMapping("/shopweb-check/internalOpen/getSceneListByDeviceId")
    R<List<SceneVo>> getSceneListByDeviceId(@RequestParam("deviceId") Integer deviceId);

    @GetMapping("/shopweb-check/internalOpen/getTemplateById")
    BaseResult<CheckTemplateVo> getTemplateById(@RequestParam("id") Integer id);

    @PostMapping("/shopweb-check/internalOpen/getTemplateByIds")
    BaseResult<List<CheckTemplateVo>> getTemplateByIds(@RequestBody List<Integer> ids);

    /**
     * 转移单据
     * @param dto
     * @return 失败列表
     */
    @PostMapping("/shopweb-check/internalOpen/dataTransfer")
    R<List<Integer>> dataTransfer(@RequestBody DataTransferDTO dto);

    @PostMapping("/shopweb-check/internalOpen/deptMonthlySummary")
    R<List<DeptSummaryVo>> deptMonthlySummary(@RequestBody List<Integer> deptIds);
    @PostMapping("/shopweb-check/internalOpen/getCheckTaskResult")
    R<List<CheckResultVo>> getCheckTaskResult(@RequestBody List<Integer> idList);

    @PostMapping("/shopweb-check/internalOpen/getUsersDeptTimeSummary")
    R<List<ActivityTrackPeriodSum>> getUsersDeptTimeSummary(@RequestBody ActivityTrackSearchInfo searchInfo);
}