package com.ovopark.check.core;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author 潘思凡
 * @since 2024/9/29 13:26
 */
@Data
public class SaveFlowCmd {

    /**
     * 唯一标识
     */
    private String unique;

    private String name;

    private String remark;
    /**
     * 分组类型
     * REPORT_IN_ADVANCE.门店报备
     */
    private String type;

    private Long enterpriseId;
    private Long userId;

    //    private List<Edge> edges;
    /**
     * 第一个节点
     */
    private Node node;

//    public List<Edge> getEdges() {
//        final Edge edge = new Edge();
//        edge.setNode(node);
//        return Collections.singletonList(edge);
//    }


    @Data
    public static class Node {
//        private Long id;
        private String name;
        /**
         * OR (default), AND
         */
        private String logic;
        private List<Part> parts;
        /**
         * 条件分支
         */
        private List<Edge> edges;

        @Deprecated
        private String symbolPrefix;
        @Deprecated
        private List<String> values;

        public List<Part> getParts() {
            if (CollectionUtils.isEmpty(parts)) {
                if (Objects.equals("DML", symbolPrefix)) {
                    return values.stream().map(v->{
                        final Part p = new Part();
                        p.setSymbol(symbolPrefix +v);
                        return p;
                    }).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty(values)) {
                    final Part p = new Part();
                    p.setSymbol(symbolPrefix);
                    return Collections.singletonList(p);
                }
                return values.stream().map(v->{
                    final Part p = new Part();
                    p.setSymbol(symbolPrefix+ "_" +v);
                    return p;
                }).collect(Collectors.toList());
            }
            return parts;
        }
    }

    @Data
    public static class Part {
//        private Long id;
        /**
         * 用户id U_1,角色id R_1
         */
        private String symbol;
        private Integer seq;
//        private String name;
    }

    @Data
    public static class Edge {
//        private Long id;
//        private String name;
        /**
         * 条件, 例如符合组织架构 O_1,S_2
         */
        private List<String> conditions;
        private Integer seq;
        /**
         * 下一个节点
         */
        private Node node;
    }

}
