package com.ovopark.check.problem;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class AIProblemVo implements Serializable {
    private static final long serialVersionUID = -1L;
    /**
     * 待办单id
     */
    private Integer id;
    /**
     * AI记录 id & time
     */
    private List<LogBo> logs;
    /**
     * 点检项id
     */
    private Integer itemId;
    /**
     * 点检项
     */
    private String itemName;
    /**
     * 整改图片
     */
    private List<String> url = new ArrayList<>();
    /**
     * 整改图片链接
     */
    private String reformUrl;
    /**
     * 整改人
     */
    private String reformer;
    /**
     * 是否整改
     */
    private Integer reformed;
    /**
     * 整改次数
     */
    private Integer reformNum;
    /**
     * 复检人
     */
    private String checker;
    /**
     * 是否复检
     */
    private Integer checked;
    /**
     * 复检次数
     */
    private Integer checkNum;
    /**
     * 企业id
     */
    private Integer enterpriseId;
    /**
     * 门店id
     */
    private Integer depId;
    /**
     * 提醒
     */
    private AIRemind remind;

    public void setCheckNum(Integer checkNum) {
        this.checkNum = checkNum;
        this.checked = (checkNum > 0) ? 1 : 0;
    }

    public void setReformNum(Integer reformNum) {
        this.reformNum = reformNum;
        this.reformed = (reformNum > 0) ? 1 : 0;
    }
}
