package com.ovopark.check.core;

import com.ovopark.check.common.Command;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author 潘思凡
 * @since 2022/7/8 15:35
 */
@Data
@Accessors(chain = true)
public class CommitCheckTaskCmd extends Command {
    /**
     * 任务id
      */
    private Integer id;
    /**
     * 提交巡店时，是否在有效范围内
     */
    private Integer isInRange;
    private String inspectorPicUrl;
    private String managerPicUrl;
    private String companionPicUrl;
    private String summary;
    private List<Integer> cc2;
    /**
     * 陪同人员
     */
    private String company;
    private Integer tempId;
    private String uuid;
    private String signOutPicUrl;
    private String signOutAddress;
    private Integer onSiteUserId;
    /**
     * 是否有异议
     */
    private Boolean hasObjection;
    /**
     * 异议内容
     */
    private String objection;
    /**
     * 附录内容
     */
    private String appendixContent;
    private String doubleSignShiplog;
    private Double longitude;
    private Double latitude;
    private Double distance;
    private String netType;
    private Double battery;
    //直接提交
    private Boolean direct = false;

    /**
     * 自定义开始时间：yyyy-MM-dd HH:mm:ss
     */
    private String customStartTime;
    /**
     * 自定义结束时间:yyyy-MM-dd HH:mm:ss
     */
    private String customEndTime;
    private Boolean ignoreReview = false;
    private boolean isDemo = false;
    private String depClosure;
}
