package com.ovopark.check.problem;

import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;

@Data
public class AiRectVo {


    private Integer deptId;
    private String deptName;
    // 逾期未整改数目
    // 当前状态为待整改 或者 当前状态是问题过期且问题过期时状态为待整改
    private Integer odUnRectCount = 0;
    private Integer totalCount = 0;

    private BigDecimal odUnRectRate;


    public BigDecimal getOdUnRectRate() {
        if (this.odUnRectCount == 0) {
            return BigDecimal.ZERO;
        }
        if (totalCount == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rate = new BigDecimal(odUnRectCount + "")
                .multiply(new BigDecimal("100.0"))
                .divide(new BigDecimal(totalCount + ""), 2, RoundingMode.HALF_UP);
        return new BigDecimal(rate.stripTrailingZeros().toPlainString());
    }
}
