package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.Getter;

import java.util.Date;
import java.util.List;

@Data
public class InspectionItemVo {

    private Integer id;

    private String name;

    private String code;
    //分值
    private Double mark;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date addTime;
    //默认1为有效 无效为2
    private Integer flag = 1;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date deleteTime;

    private String remark;

    private Integer groupId;
    /**
     * 复检人
     */
    private Integer checkerRoleid;
    private String checkRoleIds;

    private Integer reformRoleid;
    private String reformRoleIds;

    /**
     * 到期时间间隔
     */
    private Integer expireInterval;

    private Integer enterpriseId;

    // 如果打分基于规则，则关联规则表 is_parent_viewshop_rules 的ID列
    private Integer ruleId;

    private Integer orderer;
    //额外扣分
    private Double extraMark = 0d;
    //0 奖励钱 1 扣钱
    private Integer moneyType = 0;

    private Double money = 0d;

    private Integer isReformed;
    //	点检类型 （1.通用点检 2.商品陈列检测,3.店员着装检测,4.OCR内容检测）
    private Integer type;
    //对应的AI点检项的ID
    private Integer aiId;

    /**
     * 点检项执行标准描述
     */
    private String standard;

    /**
     * 巡店时是否必须上传图片,0-否 1-是（合格时必传，不合格时必传）2-合格时必传 3-不合格时必传
     */
    private Integer needUpPicture;
    /**
     * 是否关联了ai应用,0:否,1：是
     */
    private Integer isRelateAi;
    /**
     * 申诉审批人角色
     */
    private Integer approverRoleId;
    /**
     * 点检项标准类型（1、图文 2、素材 3、课程）
     */
    private Integer standardType;

    /**
     * 优先级(高:3,中:2,低:1,默认：0)
     */
    private Integer priority;
    /**
     * 禁止上传图片
     */
    private Integer forbidPic;
    /**
     * 版本号
     */
    private Integer version;

    /**
     * 整改时必须完成课程|素材学习(1：是 ，0： 否)
     */
    private Integer isNeedStudy;
    /**
     * 整改上传图片仅允许实时拍照 1-是，0-否，默认为否
     */
    private Integer changePictureAllowPhotos;


    public Integer getReformRoleid(){
        if (reformRoleIds != null && !"".equals(reformRoleIds)) {
            return Integer.parseInt(reformRoleIds.split(",")[0]);
        }
        return null;
    }

    /**
     * 抄送人角色
     */
    private List<Integer> ccRoleIdList;
}
