package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.TaskResultParam;
import com.ovopark.check.Vo.TaskResultVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;
import java.util.Map;

/**
 * @author 潘思凡
 * @since 2022/12/8 10:11
 */
@FeignClient(value = "shopweb-check")
public interface LiveCheckTaskApi {

   @PostMapping("/shopweb-check/live-check-task-model/getWaitApproveTaskByPost")
   R getWaitApproveTask(@RequestHeader("Ovo-Authorization")String token,@RequestBody Map<String,Object> searchInfo);

   @PostMapping("/shopweb-check/inspItemReportTest/save")
   R saveInspItemTest(@RequestBody Map<String, Object> testInfo);



   @PostMapping("/shopweb-check/live-check-task-model/getTaskResult")
   R<List<TaskResultVo>> getTaskResult(@RequestBody TaskResultParam vo);
}
