package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

@Data
public class CaptureTaskVo {

    private Integer id;

    private Integer groupId;

    private Integer userId;

    private String name;

    private Integer frequency;

    private String cron;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Integer isProcessing;

    private String preNos;

    private Integer totalPreset;

    private Integer error;

    private String depIds;

    private String presetNameIds;

    private String dailyStartTime;

    private String dailyEndTime;

    private Integer intervalSeconds;

    private Integer isContainerTask;

    private Integer allDeps;

    private Integer jobId;

    private Integer timeZone;

    private String cronExecute;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTimeExecute;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTimeExecute;

    private String dailyStartTimeExecute;

    private String dailyEndTimeExecute;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    private Integer updatedBy;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedTime;

    private String gmsTaskId;

    private Integer snapMode;
}
