package com.ovopark.check.vos;

import lombok.Data;

/**
 * @author donily
 * @date 2022-06-30 13:53:53
 * @description 巡店排名报表 查询条件
 */
@Data
public class CheckRankingReportSearchInfo extends CheckReportSearchInfo{

    /**
     * 哪个字段排序
     */
    private Integer sortIndicator;
    /**
     * 1-升序 -1降序  0不排序
     */
    private Integer sortType;
    /**
     *@param subIndicator 细分指标排序标识, sourceType 或者 roleId
     *
     */
    private Integer subIndicator;
    /**
     * @param subIndicatorType 细分指标排序类型 0.巡店类型,1.用户角色
     */
    private Integer subIndicatorType;
    /**
     * 指标主体
     */
    private Integer indicatorSubject;
    /**
     * 0-xxx门店数量 1-xxx门店比例
     */
    private Integer gearIndicator;
    /**
     * 0-web调取 1-h5调取
     */
    private Integer whichType = 0;
    /**
     * 根据哪个门店id排序
     */
    private Integer sortDepId;
    /**
     * 根据哪个时间排序
     */
    private Integer sortTime;
}
