package com.ovopark.check.vos;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Donily
 * @since 2022-06-22 10:41:41
 * @description 指标业务类
 */
@Data
public class IndicatorDataBo implements Serializable {
    private static final long serialVersionUID = 3036888683478970243L;
    /**
     * 是否是数据汇总行
     */
    private Boolean dataSummaryLine = false;
    /*
     * 部门节点
     */
    private String depNode;
    /*
     * 部门节点名称
     */
    private String name;
    /**
     * 区域经理或者督导下的门店集合
     */
    private List<Integer> depIds;
    /**
     * 门店ID
     */
    private Integer depId;
    /**
     * 门店编码
     */
    private String shopId;
    /**
     * 所属组织架构
     */
    private String orgStructure;
    /*
     * 平均得分
     */
    private BigDecimal storeAverageScore;
    /*
     * 得分率
     */
    private BigDecimal storeScoreRate;
    /**
     * 绝对平均分
     */
    private BigDecimal storeAbsoluteAverageScore;
    /*
     * 门店检查比例
     */
    private BigDecimal storeInspectionRatio;
    /*
     * 门店合格比例
     */
    private BigDecimal storeQualifiedRatio;
    /*
     * 总门店数
     */
    private Integer storeTotalNum;
    /*
     * 优秀门店数
     */
    private Integer storeExcellentNum;
    /*
     * 合格门店数
     */
    private Integer storeQualifiedNum;
    /*
     * 不合格门店数
     */
    private Integer storeUnqualifiedNum;
    /*
     * 检查门店数
     */
    private Integer storeCheckedNum;
    /*
     * 未检查门店数
     */
    private Integer storeUncheckedNum;

    /*
     * 未检查未到访门店数
     */
    private Integer storeUncheckedOrOutsideNum;
    /*
     * 未发现问题门店数
     */
    private Integer storeNoProblemFoundNum;
    /*
     * 门店检查次数
     */
    private Integer storeInspectionNum;
    /*
     * 巡店平均时长 国际化 用于前端展示
     */
    private String storeCheckAverageDurationStr;
    /*
     * 巡店平均时长 单位秒 用于排序
     */
    private Double storeCheckAverageDuration;
    /*
     * 门店创建距今时长 国际化 用于前端展示
     */
    private String storeCreateTimePeriodStr;

    /*
     * 门店创建距今时长 用于排序
     */
    private Long storeCreateTimePeriod;
    /*
     * 累计扣分
     */
    private Double storeSumLossScore;
    /*
     * 点检项检查次数
     */
    private Integer inspectionItemTotalNum;
    /*
     * 检查项合格率
     */
    private BigDecimal inspectionItemQualifiedRate;

    /*
     * 检查项不合格率
     */
    private BigDecimal inspectionItemUnqualifiedRate;
    /*
     * 合格项数
     */
    private Integer inspectionItemQualifiedNum;
    /*
     * 不合格项数
     */
    private Integer inspectionItemUnqualifiedNum;
    /*
     * 待整改数
     */
    private Integer problemToRectificationNum;
    /*
     * 待整改率
     */
    private BigDecimal problemToRectificationRate;
    /*
     * 已完成数
     */
    private Integer problemCompletedNum;
    /*
     * 已完成率
     */
    private BigDecimal problemCompletedRate;
    /*
     * 待申诉数
     */
    private Integer problemToAppealNum;
    /*
     * 待申诉率
     */
    private BigDecimal problemToAppealRate;
    /*
     * 待审批数
     */
    private Integer problemToApprovalNum;
    /*
     * 待审批率
     */
    private BigDecimal problemToApprovalRate;
    /*
     * 申诉不通过数
     */
    private Integer problemAppealNotPassNum;
    /*
     * 申诉不通过率
     */
    private BigDecimal problemAppealNotPassRate;
    /*
     * 申诉通过数
     */
    private Integer problemAppealPassNum;
    /*
     * 申诉通过率
     */
    private BigDecimal problemAppealPassRate;

    /*
     * 待复检数
     */
    private Integer problemToRecheckNum;
    /*
     * 待复检率
     */
    private BigDecimal problemToRecheckRate;

    /*
     * 过期数
     */
    private Integer problemExpiredNum;
    /*
     * 过期率
     */
    private BigDecimal problemExpiredRate;
    /*
     * 检查人数
     */
    private Integer checkerNum;
    /*
     * 上级负责人
     */
    private String director;

    /*
     * 上级领导
     */
    private String supervisors;
    /*
     * 任务总数
     */
    private Integer taskTotalNum;
    /**
     * 有效巡店次数
     */
    private Integer validCheckNum;
    /*
     * 任务总数-点检任务
     */
    private Integer spotInspectionTaskTotalNum;
    /*
     * 任务总数-现场巡店
     */
    private Integer onSiteTaskTotalNum;
    /*
     * 任务总数-远程巡店
     */
    private Integer remoteTaskTotalNum;
    /*
     * 任务总数-门店自检
     */
    private Integer selfInspectionTaskTotalNum;
    /*
     * 上次任务距今时长 国际化 用于前端展示
     */
    private String timeStrSinceLastTask;
    /*
     * 上次任务距今时长 用于排序
     */
    private Long timeSinceLastTask;
    /*
     * 任务总时长 国际化 用于前端展示
     */
    private String taskTotalDurationStr;
    /*
     * 任务总时长 单位秒 用于排序
     */
    private Double taskTotalDuration;
    /*
     * 审批方式分布 自动/人工/不需
     */
    private String taskApprovalTypeDistribution;
    /*
     * 审批平均时长 国际化 用于前端展示
     */
    private String taskAverageApprovalDurationStr;
    /*
     * 审批平均时长 单位秒 用于排序
     */
    private Double taskAverageApprovalDuration;
    /*
     * 得分率按类型分组
     */
    private List<SimpleIndicatorDataBo> scoreRateGroupBySourceType;
    /*
     * 得分率按角色分组
     */
    private List<SimpleIndicatorDataBo> scoreRateGroupByRole;
    /*
     * 检查门店集合
     */
    private String storeCheckedNames;
    /*
     * 未检查门店名称集合
     */
    private String storeUncheckedNames;

    /*
     * 未检查门店集合
     */
    private List<StoreUncheckedBo> storeUncheckedList;

    /*
     * 未检查未到访门店 集合
     */
    private List<StoreUncheckedBo> storeUncheckedOrOutsideList;
    /*
     * 过期完成次数
     */
    private Integer problemOverdueCompletion;

    /*
     * 奖励金额
     */
    private Double rewards;

    /*
     * 惩罚金额
     */
    private Double penalty;

    /*
     * 问题逾期数：处于【已过期】的点检项数量
     */
    private Integer problemOverdueNum;

    /*
     * 问题逾期率：处于【已过期】的点检项数量 /（不合格点检项数量+申诉通过项数）
     */
    private BigDecimal problemOverdueRate;

    /*
     * 问题分享次数
     */
    private Integer problemSharedNum;

    /*
     * 亮点分享次数
     */
    private Integer lightspotSharedNum;
    /*
     * 督导
     */
    private String supervision;
    /*
     * 区域经理
     */
    private String regionalManager;

    /*
     * 门店得分率环比
     */
    private BigDecimal storeScoreRateRatio;

    /**
     * 按时完成次数=待办单流程状态显示【已完成】的【未过期】次数
     */
    private Integer problemCompletionOnTime;

    /**
     * 按时完成率=按时完成次数/（不合格次数+申诉通过次数）
     */
    private BigDecimal problemCompletionOnTimeRate;

    /**
     * 过期完成率=过期完成次数/（不合格次数+申诉通过次数）
     */
    private BigDecimal problemExpirationCompletionRate;

    /*
     * 得分率（含还回分）
     */
    private BigDecimal returnScoreRate;
    /*
     * 绝对平均分（含还回分）
     */
    private BigDecimal storeAbsoluteAverageReturnScore;
    /**
     * 门店分档xxx门店数量、xxx门店比例
     */
    private List<RankingDepartmentGearVo> rankingDepartmentGearVos;

    /**
     * 按时完成整改数
     */
    private Integer reformOnTime;
    /**
     * 过期完成整改数
     */
    private Integer reformExpire;

    /**
     * 按时完成整改率
     */
    private BigDecimal reformOnTimeRate;

    /**
     * 过期完成整改率
     */
    private BigDecimal reformExpireRate;
    /**
     * 被驳回率
     * 被驳回过的巡店任务数 / (巡店次数-无需审批的巡店任务数)*100%
     */
    private BigDecimal refusedRate;

    /**
     * 未在门店范围内提交次数
     */
    private Integer committedNotInRangeNum;
    /**
     * 未进行流转问题数即没整改过+没申诉过的问题数
     */
    private Integer notCirculatedProblemNum;

    /**
     * 问题异常数
     */
    private Integer problemExcNum;


    /**
     * 整改问题过期数目（流程状态【问题过期】且问题过期时处于【待整改】状态的点检项数量）
     *
     */
    private Integer notReformWhenExpireNum;
    /**
     * 整改问题过期数目（流程状态【问题过期】且问题过期时处于【待整改】状态的点检项数量）/所有不合格点检项数量+申诉通过次数
     *
     */
    private BigDecimal notReformWhenExpireRate;
    /**
     * 整改问题逾期数目 （是否过期【已过期】且已过期时处于【待整改】状态的点检项数量）
     *
     */
    private Integer notReformWhenInvalidNum;
    /**
     * 整改问题逾期数目 （是否过期【已过期】且已过期时处于【待整改】状态的点检项数量）/所有不合格点检项数量+申诉通过次数
     *
     */
    private BigDecimal notReformWhenInvalidRate;
    /*
     * 页面停留总时长 单位秒 用于排序
     */
    private Double totalLiveSeconds;
    /**
     * 页面停留时长
     * 国际化 用于前端展示
     */
    private String pageStayDurationStr;
    /**
     * 页面停留时长 单位秒 用于排序
     * 每次巡店的页面停留时长相加/巡店次数
     */
    private Double pageStayDuration;

}
