package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 门店场景历史记录新增参数
 */

@Data
public class SceneHistoryParam {

    /**
     * 企业ID
     */
    private Integer enterpriseId;

    /**
     * 用户ID
     */
    private Integer userId;

    /**
     * 门店ID
     */
    private Integer deptId;

    /**
     * 场景ID is_presetNames的ID
     */
    private Integer sceneModel;

    /**
     * 场景名称 is_presetNames的名称
     */
    private String sceneName;

    /**
     * 原状态:0: 未配置状态，1: 已配置状态，2：人工上传状态，3：不适用状态
     */
    private Integer originalStatus;

    /**
     * 快照：记录原状态JSON串，记录原dep_id，原scene_model,原scene_name，原device_id，原preset_no,原is_disabled,原is_extended,原is_valid,以及设备是否属于门店
     */
    private String snapshot;

    /**
     * 操作:0: 保存为已配置，1：保存为人工上传，2：保存为不适用,3:修改AI有效区域
     */
    private Integer operate;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
