package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.ChecktaskRecordVo;
import com.ovopark.check.Vo.PresetNamesVo;
import com.ovopark.check.problem.CheckProblemsVo;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName CheckTaskRecordApi
 * @Description 点检任务子记录api
 * @Author yangjie
 * @Date 2021/8/12 13:38
 */
@FeignClient(value = "shopweb-check")
public interface PresetEvaluationsApi {

    /**
     * 修改巡店记录图片
     */
    @PostMapping("/shopweb-check/internalOpen/updatePresetEvalutionsPicId")
    R<Boolean> updatePresetEvaluationsPicId(@RequestParam("taskId") Integer taskId,
                                                      @RequestParam("presetId") Integer presetId,
                                                      @RequestParam("picId") Long picId);

    @GetMapping("/shopweb-check/preset/getPresetNamesById")
    BaseResult<PresetNamesVo> getPresetNamesById(@RequestParam("id") Integer id);

    @PostMapping("/shopweb-check/preset/getPresetNamesByIds")
    BaseResult<List<PresetNamesVo>> getPresetNamesByIds(@RequestBody List<Integer> ids);
}