package com.ovopark.check.core.mutual;

import com.ovopark.utils.DateUtils;
import lombok.Data;

import java.util.Date;

/**
 * @author 潘思凡
 * @since 2022/3/1 1:51 下午
 */
@Data
public class DepMutualStateDTO {
    /**
     * 门店id
     */
    private Integer deptId;
    private Boolean granted;
    private Integer limitTimes;
    private Integer durationHours;
    private Date endTime;

    public String getTagDesc() {
        if (granted && endTime != null) {
            return DateUtils.format(endTime, "yyyy-MM-dd HH:mm") + "前巡" + limitTimes + "次";
        }
        return null;
    }
}
