package com.ovopark.check.vos;

import lombok.Data;

import java.util.List;

/**
 * @author donily
 * @date 2022-06-30 13:53:53
 * @description 巡店报表 查询条件
 */
@Data
public class CheckReportSearchInfo {

    /**
     * 自定义开始时间
     */
    private String customStartDate;

    /**
     * 自定义结束时间
     */
    private String customEndDate;

    /**
     * 时间范围
     */
    private Integer timeRange;

    /**
     * 组织架构
     */
    private List<String> depNodes;

    /**
     * 门店标签
     */
    private List<String> tagIds;
    /**
     * 角色
     */
    private List<Integer> roleIds;

    private List<Integer> userIds;

    /**
     * 模板
     */
    private List<Integer> templateIds;

    /**
     * 点检项分类
     */
    private List<Integer> inspectionItemClassificationIds;

    /**
     * 点检项
     */
    private List<Integer> inspectionItemIds;

    private List<Integer> sourceTypes;

    private Integer pageNumber;

    private Integer pageSize;

    private String openStatus;

    /**
     * 是否展示下一级
     */
    private Boolean showTheNextLevel = false;
    /**
     * 区域经理或者督导
     */
    private List<DepNodeBo> regionalManagerOrSupervisors;

    private String modes;
    /**
     * 审核人
     */
    private List<Integer> reviewerIds;

    /**
     * 是否需要汇总
     */
    private Boolean needDataSummary = false;
    /**
     * 区域经理id
     */
    private String regionalManagerId;
    /**
     * 督导id
     */
    private String supervisorId;

    /**
     * 门店类型
     */
    private List<Integer> departmentType;
    /**
     * 未检查门店下钻排名标识
     * 用来是否查询区域经理、督导等数据
     */
    private Boolean unCheckDepDrillingFlag;
    private Boolean uncheckedOrOutsideDrillingFlag;
}
