package com.ovopark.check.vos;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Donily
 * @date 2022-07-06 13:57:58
 * @description 区间的数量、占比 前端展示类
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class IntervalVo implements Serializable {
    private static final long serialVersionUID = -5171321186165140458L;
    /*
     * 开始数值
     */
    private BigDecimal start;
    /*
     * 是否包含开始数值
     */
    private Boolean containStart;
    /*
     * 结束数值
     */
    private BigDecimal end;
    /*
     * 是否包含结束数值
     */
    private Boolean containEnd;
    /*
     * 展示区间
     */
    private String showInterval;
    /*
     * 数量
     */
    private Integer num;
    /*
     * 占比
     */
    private BigDecimal proportion;

}
