package com.ovopark.api;

import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName CheckProblemsApi
 * @Description 代办单api
 * @Author yangjie
 * @Date 2021/9/23 09:58
 */
@FeignClient(value = "shopweb-check")
public interface ReportMessageApi {

    @PostMapping("/shopweb-check/report-message/getReportMessageList")
    BaseResult<List<ReportMessageVO>> getReportMessageList(@RequestParam("isRead") Integer isRead,
                                                           @RequestParam("userId") Integer userId,
                                                           @RequestParam("includeMessageTypes") String includeMessageTypes,
                                                           @RequestParam("excludeMessageTypes") String excludeMessageTypes);

    @PostMapping("/shopweb-check/report-message/readAll")
    BaseResult readAll(@RequestParam("userId") Integer userId, @RequestParam("enterpriseId") Integer enterpriseId);
}