package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class CheckTaskVo {

    private Integer id;

    private String name;

    /**
     * 点检人类型：0:按人,1:按角色
     */
    private Integer userType;

    /**
     * 点检人ID 废弃字段：2023-08-15迭代 由于可以多选用户和角色，维护在is_checktask_user表中
     */
    @Deprecated
    private Integer checker;

    /**
     * 点检角色ID 废弃字段：2023-08-15迭代 由于可以多选用户和角色，维护在is_checktask_user表中
     */
    @Deprecated
    private Integer roleId;

    /*
        门店类型,0:指定门店,1:实时门店
     */
    private Integer deptType;

    /*
        门店id，逗号隔开，实时门店在保存当时的门店id（注意：所选门店夏令时是否开启的状态必须一致的）
     */
    private String depIds;

    private Integer allDeps;

    private String presetNos;

    private Integer frequency;

    private String cron;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Integer isProcessing;

    private Date createtime;

    private Integer creater;

    private Integer validDay;

    private String dbviewshopIds;

    private Integer enterpriseId;

    private Integer sourceType;

    private Integer iscapture;


    private Integer type;//任务类型 （1.通用任务 2.AI点检任务）

    private Integer aifrequency;//AI点检任务-缉查频率（1次3次5次）

    private Integer aiinterval;//AI点检任务-间隔时间(分钟)

    private Integer times;//AI点检任务-核实多少次

    private String aiTaskIds;//Ai 点检任务子检查任务ID列表

    /**
     * 由其他时区变为东八区时，前端传值为空，更新数据库
     */
    private String timeZone;  //时区

    /**
     抄送人字符串：多抄送人以逗号隔开
     */
    private String ccUsers;

    /**
     更新人
     */
    private Integer updatedBy;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedTime;
}
