package com.ovopark.api;

import lombok.Data;

/**
 * @author 潘思凡
 * @since 2022/4/2 2:27 下午
 */
@Data
public class OpenR<T> {

    private Integer code; //错误码Int （必须）
    private String codename;
    private String result;
    private T data;
    private Boolean isError;

    public static OpenR ok() {
        OpenR openR = new OpenR();
        openR.setCode(0);
        openR.setCodename("SUCCESS");
        openR.setResult("成功");
        openR.setData(null);
        openR.setIsError(false);
        return openR;
    }

    public static <T> OpenR ok(T data) {
        OpenR openR = new OpenR();
        openR.setCode(0);
        openR.setCodename("SUCCESS");
        openR.setResult("成功");
        openR.setData(data);
        openR.setIsError(false);
        return openR;
    }

    public static OpenR error() {
        OpenR openR = new OpenR();
        openR.setCode(1);
        openR.setCodename("FAIL");
        openR.setResult("失败");
        openR.setData(null);
        openR.setIsError(true);
        return openR;
    }

}
