package com.ovopark.check.common;

import lombok.Data;

/**
 * @author 潘思凡
 * @since 2022/2/25 4:06 下午
 */
@Data
public class PageQuery extends Query {

    private Integer pageNumber;

    private Integer pageSize;

    public PageQuery(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize) {
        super(userId, enterpriseId);
        if (pageNumber == null || pageSize == null) {
            throw new RuntimeException("pageNumber and pageSize must be nonnull");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public PageQuery(Integer pageNumber, Integer pageSize) {
        if (pageNumber == null || pageSize == null) {
            throw new RuntimeException("pageNumber and pageSize must be nonnull");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }
}
