package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.EnterpriseNumberVo;
import com.ovopark.check.Vo.TaskDepartmentTagDetailVo;
import com.ovopark.check.Vo.TaskDepartmentTagDto;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.CheckscoreDailyPojo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * @author 潘思凡
 * @since 2021/12/20 11:10 上午
 */
@FeignClient(value = "shopweb-check")
public interface CheckScoreApi {

    @RequestMapping("/shopweb-check/checkscore/getCheckscoreDailysByGroupIdGroupByDepId")
    BaseResult<List<CheckscoreDailyPojo>> getCheckscoreDailysByGroupIdGroupByDepId(@RequestParam("groupId") Integer groupId, @RequestParam("stime") String stime, @RequestParam("etime") String etime);

    /**
     * 获取时间段内门店检查人数
     *
     * @param startTime
     * @param endTime
     * @param deptId
     * @return
     */
    @RequestMapping("/checkscoreUserDaily/getCheckerCount")
    R getCheckerCount(@RequestParam("startTime") Date startTime,
                      @RequestParam("endTime") Date endTime,
                      @RequestParam("deptId") Integer deptId);


    //接口 根据时间门店获取门店数据
    @RequestMapping("/shopweb-check/checkScore/getDeptReportScore")
    String getDepReportScore(@RequestParam("startTime") String startTime,
                      @RequestParam("endTime") String endTime,
                        @RequestParam("groupId") Integer groupId,
                      @RequestParam("depIds") List<Integer> depIds);

    //接口 配置标签 巡店接口
    @PostMapping("/shopweb-check/department/getStatisticsByConfig")
    BaseResult<List<EnterpriseNumberVo>> getStatisticsByConfig(@RequestBody List<EnterpriseNumberVo> enterpriseNumberVos, @RequestParam("now") String now);

    @PostMapping("/shopweb-check/department/getTaskDepartmentTagDetail")
    BaseResult<List<TaskDepartmentTagDetailVo>> getTaskDepartmentTagDetail(@RequestBody TaskDepartmentTagDto taskDepartmentTagDto);

}
