package com.ovopark.check.problem;

import com.ovopark.check.common.Command;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;

/**
* @Description: 处理待办单cmd
* @Author: Zero
* @Date: 2022/8/3
*/
@Data
@Accessors(chain = true)
@ToString
public class DealProblemCmd extends Command {

    private Integer problemId;
    //内容
    private String content;
    //图片视频json串
    private String videoAndImgAttachStr;
    //文件流
    private MultipartFile[] temps;
    //标签
    private List<Integer> tagIds;
    //审批人申诉通过： 选择的合格细则
    //整改人申诉：只是暂存选择状态
    private String okDetailIds;
    //审批人申诉通过 ：返回分数
    //整改人申诉：只是暂存分数
    private Double claimBackScore;
    //是否批量处理 跳过一些校验 例如：是否需要学习
    private Boolean isBatch = false;
    // 探店选择题
    private String option;
    // 整改返回分值 （这个分+原得分= 得分（含返回））
    private Double reformBackScore;
    // 评论@
    private List<Integer> mentionedUserIds = new ArrayList<>();
    // 操作记录id
    private Integer id;

    // 暂存的操作类型1:整改  2:不予整改 3：复检不通过  4：复检通过  -1：申诉 -3：审批不通过 -4 ：审批通过  9 终止
    private Integer operateType;
    // 重复扣分次数
    public Integer times;

    //附件
    private String attachment;

}
