package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;

/**
 * @author: chenheng@ovopark.com
 * @create: 2022-01-06 17:22
 * @description:
 **/
@FeignClient(value = "shopweb-check")
public interface CheckReportApi {

    /**
   * 添加报告消息
   * @param userId
   * @param messageId
   * @param messageType
   * @param deptId
   * @param start
   * @param end
   * @return
   */
  @RequestMapping("/report-message/insertReportMessage")
  BaseResult insertReportMessage(@RequestParam("userId") Integer userId,@RequestParam("messageId") String messageId,@RequestParam("messageType") int messageType,@RequestParam("deptId") Integer deptId,@RequestParam("start") Date start,@RequestParam("end") Date end);


    @RequestMapping("/shopweb-check/informationReport/markCount")
    R<Integer> markCount(@RequestParam("userId") Integer userId,@RequestParam("enterpriseId") Integer enterpriseId);
}
