/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopwebdetecttoolkit.tools.trace;

import com.ovopark.shopwebdetecttoolkit.tools.trace.TraceContext;
import com.ovopark.shopwebdetecttoolkit.tools.trace.TraceIdUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public class CustomThreadPoolExecutor
extends ThreadPoolExecutor {
    protected CustomThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor, TimeUnit timeUnit) {
        super(threadPoolExecutor.getCorePoolSize(), threadPoolExecutor.getMaximumPoolSize(), threadPoolExecutor.getKeepAliveTime(timeUnit), timeUnit, threadPoolExecutor.getQueue(), threadPoolExecutor.getThreadFactory(), threadPoolExecutor.getRejectedExecutionHandler());
    }

    @Override
    public void execute(Runnable command) {
        super.execute(this.wrap(command));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(this.wrap(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.wrap(task));
    }

    private TraceContext getTraceContext() {
        TraceContext traceContext = new TraceContext();
        traceContext.setTraceId(TraceIdUtils.getTraceId());
        return traceContext;
    }

    private void processTrace(TraceContext invocationContext) {
        MDC.put((String)"TraceId", (String)invocationContext.getTraceId());
    }

    private void removeTrace() {
        MDC.remove((String)"TraceId");
    }

    private Runnable wrap(final Runnable task) {
        final TraceContext invocationContext = this.getTraceContext();
        class CurrentTraceContextRunnable
        implements Runnable {
            CurrentTraceContextRunnable() {
            }

            @Override
            public void run() {
                try {
                    CustomThreadPoolExecutor.this.processTrace(invocationContext);
                    task.run();
                }
                finally {
                    CustomThreadPoolExecutor.this.removeTrace();
                }
            }
        }
        return new CurrentTraceContextRunnable();
    }

    private <C> Callable<C> wrap(final Callable<C> task) {
        final TraceContext invocationContext = this.getTraceContext();
        class CurrentTraceContextCallable
        implements Callable<C> {
            CurrentTraceContextCallable() {
            }

            @Override
            public C call() throws Exception {
                try {
                    CustomThreadPoolExecutor.this.processTrace(invocationContext);
                    Object v = task.call();
                    return v;
                }
                finally {
                    CustomThreadPoolExecutor.this.removeTrace();
                }
            }
        }
        return new CurrentTraceContextCallable();
    }
}

