/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.gw.kit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKit {
    protected static final Logger log = LoggerFactory.getLogger(FileKit.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String filePath) {
        FileInputStream in = null;
        try {
            Properties propertie = new Properties();
            in = new FileInputStream(FileKit.class.getClassLoader().getResource(filePath).getPath());
            InputStreamReader reader = new InputStreamReader((InputStream)in, "utf-8");
            propertie.load(reader);
            Properties properties = propertie;
            return properties;
        }
        catch (FileNotFoundException ex) {
            log.info("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6--->\u5931\u8d25\uff01- \u539f\u56e0\uff1a\u6587\u4ef6\u8def\u5f84\u9519\u8bef\u6216\u8005\u6587\u4ef6\u4e0d\u5b58\u5728");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            log.info("\u88c5\u8f7d\u6587\u4ef6--->\u5931\u8d25!");
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readPropertiesValue(String fileName, String key) {
        Properties prop = FileKit.readProperties(fileName);
        if (prop != null) {
            return prop.getProperty(key);
        }
        return null;
    }

    public static String readPropertiesValue(Properties prop, String key) {
        if (prop != null) {
            return prop.getProperty(key);
        }
        return null;
    }

    public static InputStream getInputStreamByGet(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            conn.setRequestProperty("Accept-Language", "zh-CN");
            conn.setRequestProperty("Charset", "UTF-8");
            if (conn.getResponseCode() == 200) {
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveData(InputStream is, File file) {
        try (BufferedInputStream bis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
                bos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

