/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.dto;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;

    public static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, "20000", "\u65e0\u6548\u7684token");
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, "20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public static <T> BaseResult<T> error(T data, String code, String message) {
        return BaseResult.getInstance(true, data, code, message);
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public T getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isError = this.getIsError();
        Boolean other$isError = other.getIsError();
        if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isError = this.getIsError();
        result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResult(isError=" + this.getIsError() + ", data=" + this.getData() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }
}

