/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.organize.common.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtils {
    private static Logger log = LoggerFactory.getLogger(TimeUtils.class);
    public static Integer DEFAULT_TIME_ZONE = 8;
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public String getTimeInterval(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        String imptimeBegin = sdf.format(cal.getTime());
        cal.add(5, 6);
        String imptimeEnd = sdf.format(cal.getTime());
        return imptimeBegin + "," + imptimeEnd;
    }

    public static Date getTheDate(int year, int month, int wek, int num, int hour, int minutes) {
        Calendar time = Calendar.getInstance();
        time.set(2, month - 1);
        int day = 1;
        if (wek >= 1 && wek <= 7) {
            if (num == 10) {
                int latDay = time.getActualMaximum(5);
                time.set(5, latDay);
                int weekd = time.get(7);
                int n = weekd = weekd == 1 ? 8 : weekd;
                day = weekd - 1 >= wek ? latDay - (weekd - 1 - wek) : latDay - (weekd - 1 - wek) - 7;
            } else {
                time.set(5, 1);
                int weekd = time.get(7);
                int n = weekd = weekd == 1 ? 8 : weekd;
                day = weekd - 1 <= wek ? wek - (weekd - 1) + (num - 1) * 7 + 1 : wek - (weekd - 1) + num * 7 + 1;
            }
        } else {
            log.error("\u661f\u671f\u683c\u5f0f\u4e0d\u6b63\u786e:" + wek);
        }
        time.set(5, day);
        time.set(11, hour);
        time.set(12, minutes);
        time.set(13, 0);
        time.set(14, 0);
        return time.getTime();
    }

    public static Date getRealDateTime(String time) {
        String[] timeArr = time.split("-");
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = Integer.parseInt(timeArr[0]);
        int num = Integer.parseInt(timeArr[1]);
        int week = Integer.parseInt(timeArr[2]);
        String hourAndMinutes = timeArr[3];
        int hour = Integer.parseInt(hourAndMinutes.split(":")[0], 10);
        int minutes = Integer.parseInt(hourAndMinutes.split(":")[1], 10);
        Date realDate = TimeUtils.getTheDate(year, month, week, num, hour, minutes);
        return realDate;
    }

    public static void main(String[] args) {
        TimeUtils.getRealDateTime("3-2-1-01:00");
    }

    public static boolean isDST(Date now, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        boolean isDst = false;
        if (isSummerTime != null && isSummerTime > 0 && summerTimeStart != null && summerTimeEnd != null) {
            if (summerTimeEnd.after(summerTimeStart)) {
                if (!now.before(summerTimeStart) && now.before(summerTimeEnd)) {
                    isDst = true;
                }
            } else {
                isDst = !now.after(summerTimeEnd) || now.after(summerTimeStart);
            }
        }
        return isDst;
    }

    public static Date getLocalTime(Date date, Integer timeZone, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        timeZone = timeZone != null ? timeZone : DEFAULT_TIME_ZONE;
        isSummerTime = isSummerTime == null ? 0 : isSummerTime;
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (timeZone <= 12) {
            cal.add(10, timeZone - DEFAULT_TIME_ZONE);
        } else {
            switch (timeZone) {
                case 13: {
                    cal.add(10, -9 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 14: {
                    cal.add(10, -3 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 15: {
                    cal.add(10, 3 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 16: {
                    cal.add(10, 4 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 17: {
                    cal.add(10, 5 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 18: {
                    cal.add(10, 6 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 19: {
                    cal.add(10, 9 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 20: {
                    cal.add(10, 10 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 21: {
                    cal.add(10, 13 - DEFAULT_TIME_ZONE);
                    break;
                }
                case 22: {
                    cal.add(10, 14 - DEFAULT_TIME_ZONE);
                    break;
                }
            }
        }
        if (TimeUtils.isDST(cal.getTime(), isSummerTime, summerTimeStart, summerTimeEnd)) {
            cal.add(10, 1);
        }
        return cal.getTime();
    }

    public static Timestamp stringToTime(String strTime) {
        if ("".equals(strTime) || strTime == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        format.setLenient(false);
        try {
            Timestamp ts = new Timestamp(format.parse(strTime).getTime());
            return ts;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Timestamp stringToDate(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        try {
            Timestamp ts = new Timestamp(format.parse(strDate).getTime());
            return ts;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Timestamp dateToDate(Date strDate) {
        try {
            Timestamp ts = new Timestamp(strDate.getTime());
            return ts;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDateTime(long time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    public static String formatDateTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        Formatter ft = new Formatter(Locale.CHINA);
        return ft.format("%1$tY-%1$tm-%1$td %1$tT", cal).toString();
    }

    public static String getCurTimeString(String format) {
        if (format == null) {
            return null;
        }
        Date nowDate = new Date();
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(nowDate);
    }

    public static String getCurTimeString() {
        Date nowDate = new Date();
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        return f.format(nowDate);
    }

    public static String getTimeString(Date date) {
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        return f.format(date);
    }

    public static Date stingToDate(String time) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date timeStrToDate(String time) {
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date timeStrToDate(String time, Integer timeZone) {
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        TimeZone srcTimeZone = timeZone > 0 ? TimeZone.getTimeZone("GMT+" + timeZone) : TimeZone.getTimeZone("GMT" + timeZone);
        f.setTimeZone(srcTimeZone);
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date timeStrToDate(String time, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long strDateToMillis(String date) {
        return TimeUtils.timeStrToDate(date).getTime();
    }

    public static long strDateToMillis(String date, Integer targetTimeZone) {
        return TimeUtils.timeStrToDate(date, targetTimeZone).getTime();
    }

    private static String dateTransformBetweenTimeZone(Date sourceDate, DateFormat formatter, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        Long targetTime = sourceDate.getTime() - (long)sourceTimeZone.getRawOffset() + (long)targetTimeZone.getRawOffset();
        return TimeUtils.getTime(new Date(targetTime), formatter);
    }

    private static String getTime(Date date, DateFormat formatter) {
        return formatter.format(date);
    }

    public static String dateTransformBetweenTimeZone(String sourceDate, Integer sourceTimeZone, Integer targetTimeZone) {
        if (sourceTimeZone == null) {
            sourceTimeZone = 8;
        }
        if (targetTimeZone == null) {
            targetTimeZone = 8;
        }
        TimeZone srcTimeZone = sourceTimeZone > 0 ? TimeZone.getTimeZone("GMT+" + sourceTimeZone) : TimeZone.getTimeZone("GMT" + sourceTimeZone);
        TimeZone destTimeZone = targetTimeZone > 0 ? TimeZone.getTimeZone("GMT+" + targetTimeZone) : TimeZone.getTimeZone("GMT" + targetTimeZone);
        SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
        f.setTimeZone(srcTimeZone);
        Date date = null;
        try {
            date = f.parse(sourceDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return TimeUtils.dateTransformBetweenTimeZone(date, f, srcTimeZone, destTimeZone);
    }

    public static String plusDay2(int num) {
        Date d = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String currdate = format.format(d);
        Calendar ca = Calendar.getInstance();
        ca.add(5, num);
        d = ca.getTime();
        String enddate = format.format(d);
        return enddate;
    }

    public static Boolean complateDay(String firstDate, String secondDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar firstCa = Calendar.getInstance();
        firstCa.setTime(format.parse(firstDate));
        Calendar secondCa = Calendar.getInstance();
        secondCa.setTime(format.parse(secondDate));
        Integer number = firstCa.compareTo(secondCa);
        return number > 0;
    }

    public static Integer complateDayNumber(String firstDate, String secondDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar firstCa = Calendar.getInstance();
        firstCa.setTime(format.parse(firstDate));
        Calendar secondCa = Calendar.getInstance();
        secondCa.setTime(format.parse(secondDate));
        Long number = firstCa.getTimeInMillis() - secondCa.getTimeInMillis();
        Integer day = Math.toIntExact(number / 1000L / 3600L / 24L);
        return day;
    }

    public static String addDay(Date d, int num) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String currdate = format.format(d);
        Calendar ca = Calendar.getInstance();
        ca.add(5, num);
        d = ca.getTime();
        String enddate = format.format(d);
        return enddate;
    }

    public static Date addDayStr(String d, int num) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        Date currdate = format.parse(d);
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(5, num);
        currdate = ca.getTime();
        String enddate = format.format(currdate);
        return currdate;
    }

    public static List<String> splitDateList(String startDate, String endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> listDate = new ArrayList<String>();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFormat.parse(startDate));
            while (calendar.getTime().before(dateFormat.parse(endDate)) || calendar.getTime().equals(endDate)) {
                listDate.add(dateFormat.format(calendar.getTime()));
                calendar.add(5, 1);
            }
            return listDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return listDate;
        }
    }

    public static String getTime(String ditNumber) {
        Long minTime = Timestamp.valueOf("1970-01-01 09:00:00").getTime();
        Long maxTime = Timestamp.valueOf("2038-01-01 11:00:00").getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (!TimeUtils.isNumberic(ditNumber)) {
            return null;
        }
        BigDecimal bd = new BigDecimal(ditNumber);
        int days = bd.intValue();
        int mills = (int)Math.round(bd.subtract(new BigDecimal(days)).doubleValue());
        Calendar c = Calendar.getInstance();
        c.set(1900, 0, 1);
        c.add(5, days - 2);
        int hour = mills / 3600;
        int minute = (mills - hour * 3600) / 60;
        int second = mills - hour * 3600 - minute * 60;
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        Date d = c.getTime();
        Timestamp t = Timestamp.valueOf(dateFormat.format(c.getTime()));
        try {
            if (minTime <= d.getTime() && d.getTime() <= maxTime) {
                return dateFormat.format(c.getTime());
            }
            return "outOfRange";
        }
        catch (Exception e) {
            System.out.println("\u4f20\u5165\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f" + c.getTime());
            return "Error";
        }
    }

    public static boolean isNumberic(String str) {
        Pattern pattern = Pattern.compile("[0-9]+\\.*[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

