/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.organize.sdk.util;

import com.ovopark.organize.common.base.BaseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class InfoFillHelper<T, M> {
    private static final Logger log = LoggerFactory.getLogger(InfoFillHelper.class);
    private final List<T> dataList;
    private final Function<M, Integer> modelDataIdKeyFunction;
    private final Map<Function<T, Integer>, BiConsumer<T, M>> fillExecutorMap = new HashMap<Function<T, Integer>, BiConsumer<T, M>>();
    private final Map<T, Map<Function<T, Integer>, BiConsumer<T, M>>> toFillExecutorMap = new HashMap<T, Map<Function<T, Integer>, BiConsumer<T, M>>>();
    private List<Integer> allToFillIdList;
    private List<M> modelDataList;

    public InfoFillHelper(List<T> dataList, Function<M, Integer> modelDataIdKeyFunction) {
        this.dataList = dataList;
        this.modelDataIdKeyFunction = modelDataIdKeyFunction;
    }

    public static <T, M> InfoFillHelper<T, M> getInstance(List<T> dataList, Function<M, Integer> keyFunction) {
        return new InfoFillHelper<T, M>(dataList, keyFunction);
    }

    public static <T, M> InfoFillHelper<T, M> getInstance(T t, Function<M, Integer> keyFunction) {
        return new InfoFillHelper<T, M>(t == null ? null : Collections.singletonList(t), keyFunction);
    }

    public InfoFillHelper<T, M> putExecutor(Function<T, Integer> integerFunction, BiConsumer<T, M> biConsumer) {
        if (integerFunction != null && biConsumer != null) {
            this.fillExecutorMap.put(integerFunction, biConsumer);
        }
        return this;
    }

    public InfoFillHelper<T, M> executeBy(Function<List<Integer>, List<M>> getModelDataFunction) {
        if (this.isNotEmpty(this.getAllToFillIdList())) {
            this.modelDataList = getModelDataFunction.apply(this.allToFillIdList);
            this.doExecuteFill();
        }
        return this;
    }

    public InfoFillHelper<T, M> executeByApi(Function<List<Integer>, BaseResult<List<M>>> getModelDataFunction) {
        if (this.isNotEmpty(this.getAllToFillIdList())) {
            try {
                BaseResult<List<M>> tBaseResult = getModelDataFunction.apply(this.allToFillIdList);
                if (tBaseResult == null || tBaseResult.getIsError().booleanValue()) {
                    return this;
                }
                this.modelDataList = (List)tBaseResult.getData();
                this.doExecuteFill();
            }
            catch (Exception e) {
                log.info("requestId {},executeFormBySafeResultData result RESULT_FAILED message {}", (Object)MDC.get((String)"requestId"), (Object)e.getMessage());
            }
        }
        return this;
    }

    public List<Integer> getAllToFillIdList() {
        if (this.isNotEmpty(this.dataList) && this.isNotEmpty(this.fillExecutorMap)) {
            Set<Function<T, Integer>> fillIdFunctionSet = this.fillExecutorMap.keySet();
            HashSet<Integer> toFillIdSet = new HashSet<Integer>();
            for (T t : this.dataList) {
                HashMap<Function<T, Integer>, BiConsumer<T, M>> currentDataExecutorMap = new HashMap<Function<T, Integer>, BiConsumer<T, M>>();
                for (Function<T, Integer> function : fillIdFunctionSet) {
                    Integer fillId = function.apply(t);
                    if (fillId == null) continue;
                    toFillIdSet.add(fillId);
                    currentDataExecutorMap.put(function, this.fillExecutorMap.get(function));
                }
                if (currentDataExecutorMap.isEmpty()) continue;
                this.toFillExecutorMap.put(t, currentDataExecutorMap);
            }
            this.allToFillIdList = new ArrayList<Integer>(toFillIdSet);
            return this.allToFillIdList;
        }
        return null;
    }

    private void doExecuteFill() {
        if (this.isNotEmpty(this.modelDataList)) {
            Map<Integer, Object> infoModelMap = this.modelDataList.stream().collect(Collectors.toMap(this.modelDataIdKeyFunction, a -> a, (k1, k2) -> k1));
            for (T t : this.dataList) {
                Map<Function<T, Integer>, BiConsumer<T, M>> tempFunctionBiConsumerMap = this.toFillExecutorMap.get(t);
                if (this.isEmpty(tempFunctionBiConsumerMap)) continue;
                for (Function<T, Integer> function : tempFunctionBiConsumerMap.keySet()) {
                    Object m;
                    Integer toFillId = function.apply(t);
                    if (toFillId == null || (m = infoModelMap.get(toFillId)) == null) continue;
                    BiConsumer<T, M> tmBiConsumer = tempFunctionBiConsumerMap.get(function);
                    tmBiConsumer.accept(t, m);
                }
            }
        }
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    private boolean isNotEmpty(Collection<?> collection) {
        return !this.isEmpty(collection);
    }

    private boolean isNotEmpty(Map<?, ?> map) {
        return !this.isEmpty(map);
    }

    public List<M> getModelDataList() {
        return this.modelDataList;
    }
}

