/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.core.cmd;

import com.ovopark.passenger.common.Command;
import com.ovopark.passenger.core.entity.EnterpriseCapability;
import com.ovopark.passenger.core.entity.EnterpriseCapabilityRepository;
import com.ovopark.passenger.core.entity.ShopFlowTag;
import com.ovopark.passenger.core.entity.ShopFlowTagRepository;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.support.Department;
import java.util.List;

public class SyncShopFlowTagCmd
implements Command {
    private ShopFlowTagRepository shopFlowTagRepository;
    private EnterpriseCapabilityRepository enterpriseCapabilityRepository;
    private Department department;

    public void setShopFlowTagRepository(ShopFlowTagRepository shopFlowTagRepository) {
        this.shopFlowTagRepository = shopFlowTagRepository;
    }

    public void setEnterpriseCapabilityRepository(EnterpriseCapabilityRepository enterpriseCapabilityRepository) {
        this.enterpriseCapabilityRepository = enterpriseCapabilityRepository;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    @Override
    public void execute() {
        boolean hasStaircase;
        this.verify();
        Integer enterpriseId = this.department.getEnterpriseId();
        Integer depId = this.department.getId();
        List capabilities = this.enterpriseCapabilityRepository.listByEnterpriseId(enterpriseId);
        boolean hasFirstFloor = hasStaircase = capabilities.stream().anyMatch(capability -> capability.getCapability().equals(EnterpriseCapability.CAPABILITY.STAIRCASE.getValue()));
        boolean hasFitting = capabilities.stream().anyMatch(capability -> capability.getCapability().equals(EnterpriseCapability.CAPABILITY.FITTING.getValue()));
        boolean hasCashier = capabilities.stream().anyMatch(capability -> capability.getCapability().equals(EnterpriseCapability.CAPABILITY.CASHIER.getValue()));
        List shopFlowTags = this.shopFlowTagRepository.listAllSysTag(depId);
        ShopFlowTag fittingTag = shopFlowTags.stream().filter(ShopFlowTag::isFittingTag).findFirst().orElse(null);
        this.shopFlowTagRepository.syncFittingTag(fittingTag, hasFitting, enterpriseId, depId);
        ShopFlowTag cashierTag = shopFlowTags.stream().filter(ShopFlowTag::isCashierTag).findFirst().orElse(null);
        this.shopFlowTagRepository.syncCashierTag(cashierTag, hasCashier, enterpriseId, depId);
        ShopFlowTag staircaseTag = shopFlowTags.stream().filter(ShopFlowTag::isStaircaseTag).findFirst().orElse(null);
        this.shopFlowTagRepository.syncStaircaseTag(staircaseTag, hasStaircase, enterpriseId, depId);
        ShopFlowTag firstFloorTag = shopFlowTags.stream().filter(ShopFlowTag::isFirstFloorTag).findFirst().orElse(null);
        this.shopFlowTagRepository.syncFirstFloorTag(firstFloorTag, hasFirstFloor, enterpriseId, depId);
    }

    private void verify() {
        if (this.shopFlowTagRepository == null || this.enterpriseCapabilityRepository == null || this.department == null) {
            throw new BizException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
    }
}

