/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.occupancy.qry;

import com.google.common.collect.Lists;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.occupancy.dto.OccupancyReportDto;
import com.ovopark.passenger.occupancy.dto.OccupancyReportLineDto;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourly;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourlyRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import com.ovopark.passenger.support.Department;
import com.ovopark.passenger.support.DepartmentRepository;
import com.ovopark.passenger.util.CategoriesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class OccupancyRegionalQryExecutor {
    private static final Logger log = LoggerFactory.getLogger(OccupancyRegionalQryExecutor.class);
    private OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository;
    private DepartmentRepository departmentRepository;
    private OccupancyRegionalPlanRepository occupancyRegionalPlanRepository;

    public void setOccupancyRegionalHourlyRepository(OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository) {
        this.occupancyRegionalHourlyRepository = occupancyRegionalHourlyRepository;
    }

    public void setDepartmentRepository(DepartmentRepository departmentRepository) {
        this.departmentRepository = departmentRepository;
    }

    public void setOccupancyRegionalPlanRepository(OccupancyRegionalPlanRepository occupancyRegionalPlanRepository) {
        this.occupancyRegionalPlanRepository = occupancyRegionalPlanRepository;
    }

    public List<OccupancyReportDto> executeQry(String id, Integer timeType, String stime, String etime, Integer isOnBusinessTime, Integer starthour, Integer endhour) {
        ArrayList<OccupancyReportDto> result = new ArrayList<OccupancyReportDto>();
        if (this.occupancyRegionalHourlyRepository == null) {
            log.error("occupancyRegionalHourlyRepository is null");
            return result;
        }
        if (this.departmentRepository == null) {
            log.error("departmentRepository is null");
            return result;
        }
        List depIds = this.departmentRepository.getDepIdsByIdStr(id);
        if (CollectionUtils.isEmpty((Collection)depIds)) {
            return result;
        }
        Integer depId = (Integer)depIds.get(0);
        Map<Integer, String> depIdAndNameMap = this.getDepIdAndNameMap(depId);
        Map<Integer, List<OccupancyRegionalPlan>> depIdOccupancyRegionalPlans = this.getPlansByDepIds(Lists.newArrayList((Object[])new Integer[]{depId}));
        List<OccupancyRegionalPlan> occupancyRegionalPlans = depIdOccupancyRegionalPlans.get(depId);
        if (CollectionUtils.isEmpty(occupancyRegionalPlans)) {
            return result;
        }
        List<Integer> hours = new ArrayList();
        if (Objects.equals(1, isOnBusinessTime)) {
            hours = this.departmentRepository.getBusinessTimeDaily(depId, stime);
        } else {
            for (int i = starthour.intValue(); i < endhour; ++i) {
                hours.add(i);
            }
        }
        List occupancyRegionalHourlyList = this.occupancyRegionalHourlyRepository.select((List)Lists.newArrayList((Object[])new Integer[]{depId}), timeType, stime, etime, isOnBusinessTime, hours);
        Map<Integer, String> idAndNameMapByRegionalPlanIds = this.getIdAndNameMapByRegionalPlanIds(occupancyRegionalPlans);
        Map<Integer, List<OccupancyRegionalHourly>> regionalPlanIdDataMap = occupancyRegionalHourlyList.stream().collect(Collectors.groupingBy(OccupancyRegionalHourly::getRegionalPlanId));
        for (OccupancyRegionalPlan occupancyRegionalPlan : occupancyRegionalPlans) {
            OccupancyReportDto reportDto = new OccupancyReportDto();
            reportDto.setDepId(depId).setDepName(depIdAndNameMap.get(depId)).setRegionalPlanId(occupancyRegionalPlan.getId()).setRegionalPlanName(occupancyRegionalPlan.getRegionalPlanName());
            List<Object> lines = new ArrayList();
            List<OccupancyReportLineDto> seriesOnlyTime = OccupancyRegionalQryExecutor.listOccupancyReportVos(timeType, stime, etime, starthour, endhour);
            List<OccupancyRegionalHourly> original = regionalPlanIdDataMap.get(occupancyRegionalPlan.getId());
            if (CollectionUtils.isEmpty(original)) {
                lines = seriesOnlyTime;
            } else {
                for (OccupancyReportLineDto occupancyReportLineDto : seriesOnlyTime) {
                    for (OccupancyRegionalHourly hourly : original) {
                        occupancyReportLineDto.setDepId(hourly.getDepId());
                        occupancyReportLineDto.setDepName(depIdAndNameMap.get(hourly.getDepId()));
                        occupancyReportLineDto.setRegionalPlanId(hourly.getRegionalPlanId());
                        occupancyReportLineDto.setRegionalPlanName(idAndNameMapByRegionalPlanIds.get(hourly.getRegionalPlanId()));
                        if (!StringUtils.equals((CharSequence)occupancyReportLineDto.getTime(), (CharSequence)hourly.getTime())) continue;
                        occupancyReportLineDto.setPassengerFlow(hourly.getTotalPassengerFLow());
                        BigDecimal stayTimeBig = NumberUtils.getDivide((Number)hourly.getTotalStayTime(), (Number)hourly.getTotalPassengerFLow(), (int)2);
                        occupancyReportLineDto.setStayTime(Objects.nonNull(stayTimeBig) ? Long.valueOf(stayTimeBig.longValue()) : null);
                    }
                }
                int regionalPlanIdTotalPassengerFlow = original.stream().mapToInt(OccupancyRegionalHourly::getTotalPassengerFLow).sum();
                long regionalPlanIdTotalStayTime = original.stream().mapToLong(OccupancyRegionalHourly::getTotalStayTime).sum();
                for (OccupancyReportLineDto lineDto : seriesOnlyTime) {
                    lineDto.setDepId(depId);
                    lineDto.setDepName(depIdAndNameMap.get(depId));
                    lineDto.setRegionalPlanId(lineDto.getRegionalPlanId());
                    lineDto.setRegionalPlanName(idAndNameMapByRegionalPlanIds.get(lineDto.getRegionalPlanId()));
                    if (!"total".equals(lineDto.getTime())) continue;
                    lineDto.setPassengerFlow(regionalPlanIdTotalPassengerFlow);
                    BigDecimal stayTimeBig = NumberUtils.getDivide((Number)regionalPlanIdTotalStayTime, (Number)regionalPlanIdTotalPassengerFlow, (int)2);
                    lineDto.setStayTime(Objects.nonNull(stayTimeBig) ? Long.valueOf(stayTimeBig.longValue()) : null);
                    break;
                }
                lines = seriesOnlyTime;
            }
            reportDto.setLines(lines);
            result.add(reportDto);
        }
        List hasDataDepLines = occupancyRegionalHourlyList.stream().collect(Collectors.groupingBy(OccupancyRegionalHourly::getTime)).entrySet().stream().map(entry -> {
            OccupancyReportLineDto depVo = new OccupancyReportLineDto();
            String time = (String)entry.getKey();
            List regionalPlanReportVos = (List)entry.getValue();
            int depPassengerFlow = regionalPlanReportVos.stream().mapToInt(OccupancyRegionalHourly::getTotalPassengerFLow).sum();
            long depStayTime = regionalPlanReportVos.stream().mapToLong(OccupancyRegionalHourly::getTotalStayTime).sum();
            BigDecimal stayTimeBig = NumberUtils.getDivide((Number)depStayTime, (Number)depPassengerFlow, (int)2);
            depVo.setDepId(depId).setDepName((String)depIdAndNameMap.get(depId)).setTime(time).setPassengerFlow(depPassengerFlow).setStayTime(Objects.nonNull(stayTimeBig) ? Long.valueOf(stayTimeBig.longValue()) : null).setSumStayTime(depStayTime);
            return depVo;
        }).collect(Collectors.toList());
        List<OccupancyReportLineDto> depSeriesOnlyTime = OccupancyRegionalQryExecutor.listOccupancyReportVos(timeType, stime, etime, starthour, endhour);
        block5: for (OccupancyReportLineDto depLineDto : depSeriesOnlyTime) {
            if (!CollectionUtils.isNotEmpty(hasDataDepLines)) continue;
            for (Object hasDataDepLine : hasDataDepLines) {
                depLineDto.setDepId(depId).setDepName(depIdAndNameMap.get(depId));
                if (!StringUtils.equals((CharSequence)depLineDto.getTime(), (CharSequence)((OccupancyReportLineDto)hasDataDepLine).getTime())) continue;
                BeanUtils.copyProperties((Object)hasDataDepLine, (Object)depLineDto);
                BigDecimal stayTimeBig = NumberUtils.getDivide((Number)((OccupancyReportLineDto)hasDataDepLine).getSumStayTime(), (Number)((OccupancyReportLineDto)hasDataDepLine).getPassengerFlow(), (int)2);
                depLineDto.setPassengerFlow(((OccupancyReportLineDto)hasDataDepLine).getPassengerFlow()).setStayTime(Objects.nonNull(stayTimeBig) ? Long.valueOf(stayTimeBig.longValue()) : null).setSumStayTime(((OccupancyReportLineDto)hasDataDepLine).getStayTime());
                continue block5;
            }
        }
        int depTotalPassengerFlow = hasDataDepLines.stream().mapToInt(OccupancyReportLineDto::getPassengerFlow).sum();
        long depTotalStayTime = hasDataDepLines.stream().mapToLong(OccupancyReportLineDto::getSumStayTime).sum();
        for (OccupancyReportLineDto depLineDto : depSeriesOnlyTime) {
            if (!"total".equals(depLineDto.getTime())) continue;
            depLineDto.setPassengerFlow(depTotalPassengerFlow);
            BigDecimal stayTimeBig = NumberUtils.getDivide((Number)depTotalStayTime, (Number)depTotalPassengerFlow, (int)2);
            depLineDto.setStayTime(Objects.nonNull(stayTimeBig) ? Long.valueOf(stayTimeBig.longValue()) : null);
            break;
        }
        OccupancyReportDto depReportDto = new OccupancyReportDto();
        depReportDto.setDepId(depId).setDepName(depIdAndNameMap.get(depId)).setLines(depSeriesOnlyTime).setIsDep(true);
        result.add(depReportDto);
        result.sort(Comparator.comparing(OccupancyReportDto::getIsDep).reversed());
        return result;
    }

    private Map<Integer, List<OccupancyRegionalPlan>> getPlansByDepIds(List<Integer> depIds) {
        Map<Integer, List<OccupancyRegionalPlan>> map = new HashMap<Integer, List<OccupancyRegionalPlan>>();
        List occupancyRegionalPlans = this.occupancyRegionalPlanRepository.listByDepIds(depIds);
        if (CollectionUtils.isEmpty((Collection)occupancyRegionalPlans)) {
            return map;
        }
        map = occupancyRegionalPlans.stream().collect(Collectors.groupingBy(OccupancyRegionalPlan::getDepId));
        return map;
    }

    private Map<Integer, String> getDepIdAndNameMap(Integer depId) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (this.departmentRepository == null) {
            log.error("departmentRepository is null");
            return result;
        }
        Department department = this.departmentRepository.getById(depId);
        result.put(department.getId(), department.getName());
        return result;
    }

    private Map<Integer, String> getIdAndNameMapByRegionalPlanIds(List<OccupancyRegionalPlan> regionalPlans) {
        Map<Integer, String> result = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(regionalPlans)) {
            return result;
        }
        result = regionalPlans.stream().collect(Collectors.toMap(OccupancyRegionalPlan::getId, OccupancyRegionalPlan::getRegionalPlanName));
        return result;
    }

    private static List<OccupancyReportLineDto> listOccupancyReportVos(Integer timeType, String stime, String etime, Integer starthour, Integer endhour) {
        ArrayList<OccupancyReportLineDto> result = new ArrayList<OccupancyReportLineDto>();
        List categories = CategoriesUtil.getCategoriesByTimeTypeAndWorkerHourFromStimeToEtime((String)stime, (String)etime, (Integer)timeType, (Integer)starthour, (Integer)endhour, null);
        if (CollectionUtils.isNotEmpty((Collection)categories)) {
            for (String category : categories) {
                OccupancyReportLineDto data = new OccupancyReportLineDto();
                data.setTime(category);
                result.add(data);
            }
        }
        OccupancyReportLineDto totalData = new OccupancyReportLineDto();
        totalData.setTime("total");
        result.add(totalData);
        return result;
    }
}

