/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.occupancy.qry;

import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.occupancy.entity.DepartmentOccupancyData;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourly;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourlyRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import com.ovopark.passenger.occupancy.entity.ProvinceDepPeopleData;
import com.ovopark.passenger.occupancy.entity.ProvinceDepPeopleDataRepository;
import com.ovopark.passenger.occupancy.entity.ProvinceOccupancyData;
import com.ovopark.passenger.pojo.Authenticator;
import com.ovopark.passenger.support.DepartmentRepository;
import com.ovopark.passenger.support.Province;
import com.ovopark.passenger.support.SimpleOrgNode;
import com.ovopark.passenger.util.TimeUtils;
import com.ovopark.utils.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvinceOccupancyDataQryExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProvinceOccupancyDataQryExecutor.class);
    private DepartmentRepository departmentRepository;
    private OccupancyRegionalPlanRepository occupancyRegionalPlanRepository;
    private ProvinceDepPeopleDataRepository provinceDepPeopleDataRepository;
    private OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository;

    public void setDepartmentRepository(DepartmentRepository departmentRepository) {
        this.departmentRepository = departmentRepository;
    }

    public void setOccupancyRegionalPlanRepository(OccupancyRegionalPlanRepository occupancyRegionalPlanRepository) {
        this.occupancyRegionalPlanRepository = occupancyRegionalPlanRepository;
    }

    public void setProvinceDepPeopleDataRepository(ProvinceDepPeopleDataRepository provinceDepPeopleDataRepository) {
        this.provinceDepPeopleDataRepository = provinceDepPeopleDataRepository;
    }

    public void setOccupancyRegionalHourlyRepository(OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository) {
        this.occupancyRegionalHourlyRepository = occupancyRegionalHourlyRepository;
    }

    public List<ProvinceOccupancyData> executeQry(Integer userId, Integer enterpriseId) {
        if (enterpriseId == null || userId == null) {
            return new ArrayList<ProvinceOccupancyData>();
        }
        if (this.departmentRepository == null) {
            log.error("departmentRepository is null");
            return new ArrayList<ProvinceOccupancyData>();
        }
        if (this.occupancyRegionalPlanRepository == null) {
            log.error("occupancyRegionalPlanRepository is null");
            return new ArrayList<ProvinceOccupancyData>();
        }
        Map provinceDeps = this.departmentRepository.getProvinceDeps(userId, enterpriseId);
        if (provinceDeps == null || provinceDeps.isEmpty()) {
            return new ArrayList<ProvinceOccupancyData>();
        }
        ArrayList<ProvinceOccupancyData> res = new ArrayList<ProvinceOccupancyData>();
        List depIds = provinceDeps.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).map(SimpleOrgNode::getId).collect(Collectors.toList());
        Map<Integer, List<OccupancyRegionalPlan>> depRegionalPlansMap = this.occupancyRegionalPlanRepository.listByDepIds(depIds).stream().collect(Collectors.groupingBy(OccupancyRegionalPlan::getDepId));
        Date now = Authenticator.getInstance().now();
        Date startTime = TimeUtils.getStartTimeOfDay((Date)now);
        Date endTime = TimeUtils.getEndTimeOfDay((Date)now);
        Map<Integer, List<OccupancyRegionalHourly>> depRegionalHourlyListMap = this.occupancyRegionalHourlyRepository.getOccupancyRegionalHourlyListByDepIds(depIds, startTime, endTime).stream().collect(Collectors.groupingBy(OccupancyRegionalHourly::getDepId));
        for (Map.Entry entry : provinceDeps.entrySet()) {
            Province province = (Province)entry.getKey();
            List dep = (List)entry.getValue();
            List departmentDataList = dep.stream().filter(d -> depRegionalPlansMap.containsKey(d.getId())).map(d -> {
                DepartmentOccupancyData departmentOccupancyData = new DepartmentOccupancyData();
                List occupancyRegionalPlans = Optional.ofNullable(depRegionalPlansMap.get(d.getId())).orElse(new ArrayList());
                Integer peopleNum = occupancyRegionalPlans.stream().mapToInt(OccupancyRegionalPlan::getRegulation).sum();
                Integer occupiedRegionNum = (int)occupancyRegionalPlans.stream().filter(p -> p.getRegulation() > 0).count();
                Integer regionNum = occupancyRegionalPlans.size();
                BigDecimal occupancyRate = NumberUtils.calculateRate((Number)occupiedRegionNum, (Number)regionNum, (Integer)2, (boolean)false);
                List occupancyRegionalHourlyList = Optional.ofNullable(depRegionalHourlyListMap.get(d.getId())).orElse(new ArrayList());
                Integer depTableTurnoverCount = occupancyRegionalHourlyList.stream().mapToInt(OccupancyRegionalHourly::getTableTurnoverCount).sum();
                BigDecimal tableOverRate = NumberUtils.getDivide((Number)depTableTurnoverCount, (Number)regionNum, (int)2);
                departmentOccupancyData.setDepId(d.getId());
                departmentOccupancyData.setDepName(d.getName());
                departmentOccupancyData.setPeopleNum(peopleNum);
                departmentOccupancyData.setOccupiedRegionNum(occupiedRegionNum);
                departmentOccupancyData.setRegionNum(regionNum);
                departmentOccupancyData.setOccupancyRate(occupancyRate);
                departmentOccupancyData.setTableTurnoverCount(depTableTurnoverCount);
                departmentOccupancyData.setTableOverRate(tableOverRate);
                return departmentOccupancyData;
            }).sorted(Comparator.comparing(DepartmentOccupancyData::getOccupancyRate).reversed()).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(departmentDataList)) continue;
            ProvinceOccupancyData provinceOccupancyData = new ProvinceOccupancyData();
            provinceOccupancyData.setProvince(province);
            provinceOccupancyData.setDepartmentDataList(departmentDataList);
            res.add(provinceOccupancyData);
        }
        return res;
    }

    public List<ProvinceOccupancyData> executeFauxQry() {
        ArrayList<ProvinceOccupancyData> result = new ArrayList<ProvinceOccupancyData>();
        if (this.provinceDepPeopleDataRepository == null) {
            log.error("provinceDepPeopleDataRepository is null");
            return result;
        }
        String nowFormatTime = DateUtils.getNow((String)DateUtils.FORMAT_TIME);
        List provinceDepPeopleDataList = this.provinceDepPeopleDataRepository.listByNowFormatTime(nowFormatTime);
        if (CollectionUtils.isEmpty((Collection)provinceDepPeopleDataList)) {
            return result;
        }
        Map<String, List<ProvinceDepPeopleData>> map = provinceDepPeopleDataList.stream().collect(Collectors.groupingBy(ProvinceDepPeopleData::getProvinceName));
        for (Map.Entry<String, List<ProvinceDepPeopleData>> entry : map.entrySet()) {
            ProvinceOccupancyData provinceOccupancyData = new ProvinceOccupancyData();
            String provinceName = entry.getKey();
            List<ProvinceDepPeopleData> dataList = entry.getValue();
            Province province = new Province();
            province.setCode(null);
            province.setName(provinceName);
            provinceOccupancyData.setProvince(province);
            List departmentDataList = dataList.stream().map(e -> {
                DepartmentOccupancyData departmentOccupancyData = new DepartmentOccupancyData();
                departmentOccupancyData.setDepId(e.getDepId());
                departmentOccupancyData.setDepName(e.getDepName());
                departmentOccupancyData.setPeopleNum(e.getPeopleNum());
                departmentOccupancyData.setOccupancyRate(NumberUtils.keep2Decimal((Double)e.getOccupancyRate()));
                departmentOccupancyData.setTableOverRate(NumberUtils.keep2Decimal((Double)e.getTableOverRate()));
                departmentOccupancyData.setRegionNum(e.getRegionalPlanNum());
                departmentOccupancyData.setOccupiedRegionNum(Integer.valueOf(new BigDecimal("" + (double)e.getRegionalPlanNum().intValue() * e.getOccupancyRate() * 0.01).setScale(0, RoundingMode.HALF_UP).intValue()));
                return departmentOccupancyData;
            }).collect(Collectors.toList());
            provinceOccupancyData.setDepartmentDataList(departmentDataList);
            result.add(provinceOccupancyData);
        }
        return result;
    }

    public List<ProvinceOccupancyData> fusionAndSortList(List<ProvinceOccupancyData> provinceOccupancyData) {
        List<Object> res = new ArrayList<ProvinceOccupancyData>();
        if (CollectionUtils.isEmpty(provinceOccupancyData)) {
            return res;
        }
        provinceOccupancyData = provinceOccupancyData.stream().collect(Collectors.groupingBy(data -> data.getProvince().getName())).values().stream().map(list -> {
            ProvinceOccupancyData combinedData = new ProvinceOccupancyData();
            combinedData.setProvince(((ProvinceOccupancyData)list.get(0)).getProvince());
            List combinedDepartmentDataList = list.stream().flatMap(data -> data.getDepartmentDataList().stream()).collect(Collectors.toList());
            combinedData.setDepartmentDataList(combinedDepartmentDataList);
            return combinedData;
        }).collect(Collectors.toList());
        res = provinceOccupancyData.stream().sorted((o1, o2) -> {
            List<String> priorityProvinces = Arrays.asList("\u5e7f\u4e1c\u7701", "\u4e0a\u6d77", "\u5317\u4eac");
            String name1 = o1.getProvince().getName();
            String name2 = o2.getProvince().getName();
            int index1 = priorityProvinces.indexOf(name1);
            int index2 = priorityProvinces.indexOf(name2);
            if (index1 != -1 && index2 != -1) {
                return Integer.compare(index1, index2);
            }
            if (index1 != -1) {
                return -1;
            }
            if (index2 != -1) {
                return 1;
            }
            return name1.compareTo(name2);
        }).collect(Collectors.toList());
        return res;
    }
}

