/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.core.cmd;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.device.cloud.common.model.mo.SetMultiReidCfgMo;
import com.ovopark.device.signalling.model.response.SetMultiReidCfgRes;
import com.ovopark.passenger.common.Aggregate;
import com.ovopark.passenger.common.Command;
import com.ovopark.passenger.common.enums.ProductAreaTypeEnum;
import com.ovopark.passenger.core.entity.DeviceGroup;
import com.ovopark.passenger.core.entity.DeviceGroupRepository;
import com.ovopark.passenger.core.entity.DeviceProductArea;
import com.ovopark.passenger.core.entity.GroupDevice;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.pojo.Authenticator;
import com.ovopark.passenger.service.NvrReidConfigService;
import com.ovopark.passenger.support.DeviceRepository;
import com.ovopark.passenger.support.DeviceStatus;
import com.ovopark.passenger.support.HotspotDeviceArea;
import com.ovopark.pojo.UserPojo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveDeviceGroupCmd
implements Command {
    private static final Logger log = LoggerFactory.getLogger(SaveDeviceGroupCmd.class);
    private SetMultiReidCfgMo setMultiReidCfgMo;
    private DeviceGroupRepository deviceGroupRepository;
    private DeviceRepository deviceRepository;
    private NvrReidConfigService nvrReidConfigService;

    public void setSetMultiReidCfgMo(SetMultiReidCfgMo setMultiReidCfgMo) {
        this.setMultiReidCfgMo = setMultiReidCfgMo;
    }

    public void setDeviceGroupRepository(DeviceGroupRepository deviceGroupRepository) {
        this.deviceGroupRepository = deviceGroupRepository;
    }

    public void setDeviceRepository(DeviceRepository deviceRepository) {
        this.deviceRepository = deviceRepository;
    }

    public void setNvrReidConfigService(NvrReidConfigService nvrReidConfigService) {
        this.nvrReidConfigService = nvrReidConfigService;
    }

    @Override
    public void execute() {
        if (this.setMultiReidCfgMo == null || this.deviceGroupRepository == null || this.deviceRepository == null || this.nvrReidConfigService == null) {
            return;
        }
        Integer nvrDeviceId = this.setMultiReidCfgMo.getDeviceStatusId();
        DeviceStatus nvrDevice = this.deviceRepository.getById(nvrDeviceId);
        if (nvrDevice == null) {
            log.warn("nvr\u8bbe\u5907\u4e0d\u5b58\u5728, setMultiReidCfgMo:{}", (Object)this.setMultiReidCfgMo);
            return;
        }
        UserPojo user = Authenticator.getInstance().getCurrentUser();
        if (user.getGroupId() == null) {
            user.setGroupId(nvrDevice.getEnterpriseId());
        }
        Map<Integer, DeviceStatus> channelIdDeviceMap = this.deviceRepository.listIpcByNvrDeviceId(nvrDeviceId).stream().collect(Collectors.toMap(DeviceStatus::getChannelId, Function.identity()));
        List aggregates = this.deviceGroupRepository.listByMasterMac(nvrDevice.getMac());
        SetMultiReidCfgRes config = this.setMultiReidCfgMo.getConfig();
        List deviceGroups = Optional.ofNullable(config).map(SetMultiReidCfgRes::getGroups).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(deviceGroups)) {
            aggregates.forEach(Aggregate::remove);
        }
        HashMap<SetMultiReidCfgRes.GroupsDTO, DeviceGroup> deviceGroupMap = new HashMap<SetMultiReidCfgRes.GroupsDTO, DeviceGroup>();
        HashMap<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO, DeviceProductArea> areaMap = new HashMap<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO, DeviceProductArea>();
        HashMap<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.LinesDTO, DeviceProductArea> lineMap = new HashMap<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.LinesDTO, DeviceProductArea>();
        ArrayList<DeviceGroup> addGroups = new ArrayList<DeviceGroup>();
        ArrayList<Aggregate> reconfigureGroups = new ArrayList<Aggregate>();
        ArrayList<GroupDevice> addAreaDevices = new ArrayList<GroupDevice>();
        for (int i = deviceGroups.size() - 1; i >= 0; --i) {
            SetMultiReidCfgRes.GroupsDTO deviceGroupDto = (SetMultiReidCfgRes.GroupsDTO)deviceGroups.get(i);
            if (deviceGroupDto.getGroupId() == null) {
                DeviceGroup deviceGroup2 = new DeviceGroup();
                deviceGroup2.setDepId(nvrDevice.getDepId());
                deviceGroup2.setMasterMac(nvrDevice.getMac());
                deviceGroup2.setName(deviceGroupDto.getGroupName());
                deviceGroup2.setIsDelete(Boolean.valueOf(false));
                ArrayList<GroupDevice> devices = new ArrayList<GroupDevice>();
                List deviceDtoList = deviceGroupDto.getChannelCfgs();
                if (CollectionUtils.isNotEmpty((Collection)deviceDtoList)) {
                    for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO deviceDto2 : deviceDtoList) {
                        GroupDevice groupDevice2 = new GroupDevice();
                        groupDevice2.setChannelId(deviceDto2.getChannelId());
                        DeviceStatus device2 = this.getDevice(deviceDto2.getChannelId(), channelIdDeviceMap);
                        groupDevice2.setDeviceId(device2.getId());
                        groupDevice2.setMac(device2.getMac());
                        groupDevice2.setIsDelete(Boolean.valueOf(false));
                        devices.add(groupDevice2);
                        List<DeviceProductArea> deviceProductAreas = this.getDeviceProductAreas(deviceDto2, areaMap, lineMap, channelIdDeviceMap);
                        groupDevice2.setDeviceProductAreas(deviceProductAreas);
                    }
                }
                deviceGroup2.setDevices(devices);
                addGroups.add(deviceGroup2);
                deviceGroupMap.put(deviceGroupDto, deviceGroup2);
                continue;
            }
            Aggregate aggregate2 = aggregates.stream().filter(agg -> ((DeviceGroup)agg.getRoot()).getId().equals(deviceGroupDto.getGroupId()) && Objects.equals(((DeviceGroup)agg.getRoot()).getDepId(), nvrDevice.getDepId())).findFirst().orElse(null);
            if (aggregate2 != null) {
                DeviceGroup deviceGroup3 = (DeviceGroup)aggregate2.getRoot();
                deviceGroup3.setName(deviceGroupDto.getGroupName());
                List devices = deviceGroup3.getDevices();
                List deviceDtos = deviceGroupDto.getChannelCfgs();
                ArrayList<GroupDevice> removeDevices = new ArrayList<GroupDevice>();
                if (CollectionUtils.isEmpty((Collection)deviceDtos)) {
                    devices.clear();
                    removeDevices.addAll(devices);
                } else {
                    DeviceStatus device3;
                    List deviceProductAreas;
                    boolean reconfigure = false;
                    for (GroupDevice groupDevice3 : devices) {
                        if (!deviceDtos.stream().noneMatch(deviceDto -> {
                            DeviceStatus device = this.getDevice(deviceDto.getChannelId(), channelIdDeviceMap);
                            return device.getId().equals(groupDevice3.getDeviceId()) && device.getMac().equals(groupDevice3.getMac()) && deviceDto.getChannelId().equals(groupDevice3.getChannelId());
                        })) continue;
                        removeDevices.add(groupDevice3);
                    }
                    if (CollectionUtils.isNotEmpty(removeDevices)) {
                        removeDevices.forEach(devices::remove);
                    }
                    for (GroupDevice device4 : devices) {
                        SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO deviceDto3 = deviceDtos.stream().filter(dto -> {
                            DeviceStatus device1 = this.getDevice(dto.getChannelId(), channelIdDeviceMap);
                            return device1.getId().equals(device4.getDeviceId()) && device1.getMac().equals(device4.getMac()) && dto.getChannelId().equals(device4.getChannelId());
                        }).findFirst().orElse(null);
                        if (deviceDto3 == null) continue;
                        deviceProductAreas = this.getDeviceProductAreas(deviceDto3, areaMap, lineMap, channelIdDeviceMap);
                        List removeDeviceProductAreas = device4.getDeviceProductAreas().stream().filter(deviceProductArea -> deviceProductAreas.stream().noneMatch(productArea -> Objects.equals(productArea.getProductId(), deviceProductArea.getProductId()))).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(removeDeviceProductAreas)) {
                            device4.getDeviceProductAreas().removeAll(removeDeviceProductAreas);
                        }
                        device4.getDeviceProductAreas().forEach(deviceProductArea -> {
                            DeviceProductArea productArea = deviceProductAreas.stream().filter(area -> Objects.equals(area.getProductId(), deviceProductArea.getProductId())).findFirst().orElse(null);
                            if (productArea != null) {
                                deviceProductArea.setProductName(productArea.getProductName());
                                deviceProductArea.setInfoPubMac(productArea.getInfoPubMac());
                                deviceProductArea.setShelfId(productArea.getShelfId());
                                deviceProductArea.setEnableTouch(productArea.getEnableTouch());
                                if (productArea.getHotspotDeviceArea() != null && deviceProductArea.getHotspotDeviceArea() == null) {
                                    deviceProductArea.setHotspotDeviceArea(productArea.getHotspotDeviceArea());
                                } else if (productArea.getHotspotDeviceArea() == null && deviceProductArea.getHotspotDeviceArea() != null) {
                                    deviceProductArea.setHotspotDeviceArea(null);
                                    deviceProductArea.setHotspotAreaId(null);
                                } else if (productArea.getHotspotDeviceArea() != null && deviceProductArea.getHotspotDeviceArea() != null) {
                                    deviceProductArea.getHotspotDeviceArea().setProductName(productArea.getProductName()).setPoints(productArea.getHotspotDeviceArea().getPoints());
                                }
                            }
                        });
                        List addDeviceProductAreas = deviceProductAreas.stream().filter(productArea -> productArea.getProductId() == null).collect(Collectors.toList());
                        List removeDeviceProductAreasInDto = deviceProductAreas.stream().filter(productArea -> productArea.getProductId() != null && device4.getDeviceProductAreas().stream().noneMatch(deviceProductArea -> Objects.equals(deviceProductArea.getProductId(), productArea.getProductId()))).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(removeDeviceProductAreasInDto)) {
                            removeDeviceProductAreasInDto.stream().filter(productArea -> Objects.equals(productArea.getProductType(), 2)).forEach(addDeviceProductAreas::add);
                            log.warn("\u5546\u54c1\u533a\u57df\u62a5\u6587\u4e2d\u6709id \u4f46\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728, removeDeviceProductAreasInDto:{}", removeDeviceProductAreasInDto);
                            Optional.ofNullable(deviceDto3.getAreas()).ifPresent(a -> a.removeIf(area -> removeDeviceProductAreasInDto.stream().anyMatch(productArea -> Objects.equals(productArea.getProductId(), area.getId()))));
                            Optional.ofNullable(deviceDto3.getLines()).ifPresent(a -> a.removeIf(line -> removeDeviceProductAreasInDto.stream().anyMatch(productArea -> Objects.equals(productArea.getProductId(), line.getId()))));
                        }
                        if (!CollectionUtils.isNotEmpty(addDeviceProductAreas)) continue;
                        reconfigure = true;
                        addAreaDevices.add(device4);
                        device4.getDeviceProductAreas().addAll(addDeviceProductAreas);
                    }
                    ArrayList<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO> addDevices = new ArrayList<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO>();
                    for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO deviceDto3 : deviceDtos) {
                        device3 = this.getDevice(deviceDto3.getChannelId(), channelIdDeviceMap);
                        if (!devices.stream().noneMatch(groupDevice -> groupDevice.getDeviceId().equals(device3.getId()) && groupDevice.getMac().equals(device3.getMac()) && groupDevice.getChannelId().equals(deviceDto3.getChannelId()))) continue;
                        addDevices.add(deviceDto3);
                    }
                    if (CollectionUtils.isNotEmpty(addDevices)) {
                        reconfigure = true;
                        for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO deviceDto3 : addDevices) {
                            device3 = this.getDevice(deviceDto3.getChannelId(), channelIdDeviceMap);
                            GroupDevice groupDevice4 = new GroupDevice();
                            groupDevice4.setDeviceGroupId(deviceGroup3.getId());
                            groupDevice4.setChannelId(deviceDto3.getChannelId());
                            groupDevice4.setDeviceId(device3.getId());
                            groupDevice4.setMac(device3.getMac());
                            groupDevice4.setIsDelete(Boolean.valueOf(false));
                            devices.add(groupDevice4);
                            List<DeviceProductArea> deviceProductAreas2 = this.getDeviceProductAreas(deviceDto3, areaMap, lineMap, channelIdDeviceMap);
                            groupDevice4.setDeviceProductAreas(deviceProductAreas2);
                        }
                    }
                    if (reconfigure) {
                        reconfigureGroups.add(aggregate2);
                        for (GroupDevice device5 : devices) {
                            deviceProductAreas = device5.getDeviceProductAreas();
                            if (!CollectionUtils.isNotEmpty((Collection)deviceProductAreas)) continue;
                            for (DeviceProductArea deviceProductArea2 : deviceProductAreas) {
                                Optional.ofNullable(deviceProductArea2.getDeviceFlowTags()).ifPresent(List::clear);
                            }
                        }
                    }
                }
                devices.addAll(removeDevices.stream().filter(device -> device.getIsSlaveAdd() != null && device.getIsSlaveAdd() != false).collect(Collectors.toList()));
                continue;
            }
            log.warn("\u5206\u7ec4\u4e0d\u5b58\u5728\u6216\u8005\u662f\u810f\u6570\u636e, groupId:{}", (Object)deviceGroupDto.getGroupId());
            deviceGroups.remove(i);
        }
        aggregates.stream().filter(aggregate -> deviceGroups.stream().noneMatch(deviceGroupDto -> deviceGroupDto.getGroupId() != null && deviceGroupDto.getGroupId().equals(((DeviceGroup)aggregate.getRoot()).getId()))).forEach(Aggregate::remove);
        aggregates.stream().filter(aggregate -> aggregate.getRoot() != null && !Objects.equals(((DeviceGroup)aggregate.getRoot()).getDepId(), nvrDevice.getDepId())).forEach(Aggregate::remove);
        addGroups.forEach(deviceGroup -> aggregates.add(new Aggregate(null, (Serializable)deviceGroup)));
        this.setMultiReidCfgMo.setUserId(user.getId());
        this.nvrReidConfigService.saveAndIssued(aggregates, deviceGroupMap, areaMap, lineMap, addGroups, reconfigureGroups, this.setMultiReidCfgMo, channelIdDeviceMap, addAreaDevices);
    }

    private List<DeviceProductArea> getDeviceProductAreas(SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO deviceDto, Map<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO, DeviceProductArea> areaMap, Map<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.LinesDTO, DeviceProductArea> lineMap, Map<Integer, DeviceStatus> channelIdDeviceMap) {
        DeviceProductArea deviceProductArea;
        ArrayList<DeviceProductArea> deviceProductAreas = new ArrayList<DeviceProductArea>();
        DeviceStatus device = this.getDevice(deviceDto.getChannelId(), channelIdDeviceMap);
        if (CollectionUtils.isNotEmpty((Collection)deviceDto.getAreas())) {
            for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO area : deviceDto.getAreas()) {
                deviceProductArea = new DeviceProductArea();
                deviceProductArea.setProductId((Integer)Optional.ofNullable(area.getId()).map(Integer::parseInt).orElse(null));
                deviceProductArea.setProductType(Integer.valueOf(0));
                deviceProductArea.setProductName(area.getName());
                deviceProductArea.setDeviceId(device.getId());
                deviceProductArea.setDeviceName(device.getName());
                deviceProductArea.setMac(device.getMac());
                deviceProductArea.setDepId(device.getDepId());
                deviceProductArea.setIsDelete(Boolean.valueOf(false));
                deviceProductArea.setInfoPubMac(area.getXfMac());
                deviceProductArea.setShelfId(area.getShelfId());
                deviceProductArea.setEnableTouch(area.getEnableTouch());
                if (area.getType() != null && (area.getType().intValue() == ProductAreaTypeEnum.BOTH_P_H.getType() || area.getType().intValue() == ProductAreaTypeEnum.HOTSPOT.getType())) {
                    HotspotDeviceArea hotspotDeviceArea = new HotspotDeviceArea();
                    hotspotDeviceArea.setDeviceId(device.getId());
                    hotspotDeviceArea.setMac(device.getMac());
                    hotspotDeviceArea.setPoints(this.getPoints(area.getVertex()));
                    hotspotDeviceArea.setProductName(area.getName());
                    deviceProductArea.setHotspotDeviceArea(hotspotDeviceArea);
                }
                deviceProductAreas.add(deviceProductArea);
                if (area.getId() != null) continue;
                areaMap.put(area, deviceProductArea);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)deviceDto.getLines())) {
            for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.LinesDTO line : deviceDto.getLines()) {
                deviceProductArea = new DeviceProductArea();
                deviceProductArea.setProductId((Integer)Optional.ofNullable(line.getId()).map(Integer::parseInt).orElse(null));
                deviceProductArea.setProductType(Integer.valueOf(1));
                deviceProductArea.setProductName(line.getName());
                deviceProductArea.setDeviceId(device.getId());
                deviceProductArea.setDeviceName(device.getName());
                deviceProductArea.setMac(device.getMac());
                deviceProductArea.setDepId(device.getDepId());
                deviceProductArea.setIsDelete(Boolean.valueOf(false));
                deviceProductAreas.add(deviceProductArea);
                if (line.getId() != null) continue;
                lineMap.put(line, deviceProductArea);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)deviceDto.getPass())) {
            for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.PassDTO pass : deviceDto.getPass()) {
                deviceProductArea = new DeviceProductArea();
                deviceProductArea.setProductId(Integer.valueOf(Integer.parseInt(pass.getId())));
                deviceProductArea.setProductType(Integer.valueOf(2));
                deviceProductArea.setProductName(pass.getName());
                deviceProductArea.setDeviceId(device.getId());
                deviceProductArea.setDeviceName(device.getName());
                deviceProductArea.setMac(device.getMac());
                deviceProductArea.setDepId(device.getDepId());
                deviceProductArea.setIsDelete(Boolean.valueOf(false));
                deviceProductAreas.add(deviceProductArea);
            }
        }
        return deviceProductAreas;
    }

    private String getPoints(List<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO.VertexDTO> vertex) {
        if (CollectionUtils.isEmpty(vertex)) {
            return null;
        }
        ArrayList pointList = new ArrayList();
        for (SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO.VertexDTO vertexDTO : vertex) {
            ArrayList<Integer> point = new ArrayList<Integer>();
            point.add((int)(vertexDTO.getX() * 320.0));
            point.add((int)(vertexDTO.getY() * 240.0));
            pointList.add(point);
        }
        return JSONObject.toJSONString(pointList);
    }

    private DeviceStatus getDevice(Integer channelId, Map<Integer, DeviceStatus> channelIdDeviceMap) {
        DeviceStatus device = channelIdDeviceMap.get(channelId);
        if (device == null) {
            throw new BizException(ResultCodeEnum.EMPTY_DEVICE.getCode(), "\u8bbe\u5907\u4e0d\u5b58\u5728, channelId:" + channelId);
        }
        return device;
    }
}

