/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.dwell.cmd;

import com.google.common.collect.Lists;
import com.ovopark.passenger.common.Command;
import com.ovopark.passenger.common.QueryParam;
import com.ovopark.passenger.common.util.DateUtils;
import com.ovopark.passenger.core.entity.DeviceFlowTag;
import com.ovopark.passenger.core.entity.DeviceFlowTagRepository;
import com.ovopark.passenger.core.entity.ShopFlowTagRepository;
import com.ovopark.passenger.core.valueobject.CustomerFlowDetailRepository;
import com.ovopark.passenger.dwell.entity.DwellTimeHourlyFactory;
import com.ovopark.passenger.dwell.entity.DwellTimeHourlyRepository;
import com.ovopark.passenger.dwell.valueobject.EntryExitEventFactory;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.support.BusinessFromToTime;
import com.ovopark.passenger.support.DepartmentRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDwellTimeHourlyCmd
implements Command {
    private static final Logger log = LoggerFactory.getLogger(CreateDwellTimeHourlyCmd.class);
    private CustomerFlowDetailRepository customerFlowDetailRepository;
    private DepartmentRepository departmentRepository;
    private ShopFlowTagRepository shopFlowTagRepository;
    private DwellTimeHourlyRepository dwellTimeHourlyRepository;
    private DeviceFlowTagRepository deviceFlowTagRepository;
    private Integer depId;
    private String date;

    public void setCustomerFlowDetailRepository(CustomerFlowDetailRepository customerFlowDetailRepository) {
        this.customerFlowDetailRepository = customerFlowDetailRepository;
    }

    public void setDepartmentRepository(DepartmentRepository departmentRepository) {
        this.departmentRepository = departmentRepository;
    }

    public void setShopFlowTagRepository(ShopFlowTagRepository shopFlowTagRepository) {
        this.shopFlowTagRepository = shopFlowTagRepository;
    }

    public void setDwellTimeHourlyRepository(DwellTimeHourlyRepository dwellTimeHourlyRepository) {
        this.dwellTimeHourlyRepository = dwellTimeHourlyRepository;
    }

    public void setDeviceFlowTagRepository(DeviceFlowTagRepository deviceFlowTagRepository) {
        this.deviceFlowTagRepository = deviceFlowTagRepository;
    }

    public void setDepId(Integer depId) {
        this.depId = depId;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public void execute() {
        boolean isOnlyPc8A;
        this.verify();
        Integer tagId = this.shopFlowTagRepository.getPrimaryTagId(this.depId);
        if (tagId == null) {
            log.warn("depId:{} has no primary tag", (Object)this.depId);
            return;
        }
        List deviceFlowTags = this.deviceFlowTagRepository.listDeviceFlowTagByTagId(tagId);
        if (CollectionUtils.isEmpty((Collection)deviceFlowTags)) {
            log.warn("tagId:{} has no deviceFlowTags", (Object)tagId);
            return;
        }
        List dataTypes = deviceFlowTags.stream().map(DeviceFlowTag::getDataType).distinct().collect(Collectors.toList());
        boolean bl = isOnlyPc8A = dataTypes.size() == 1 && (Integer)dataTypes.get(0) == 7;
        if (isOnlyPc8A) {
            log.info("\u53ea\u6709pc8a \u4e0d\u8ba1\u7b97\u505c\u7559\u65f6\u957f, tagId:{}", (Object)tagId);
            return;
        }
        boolean isOnlyPc8C = dataTypes.size() == 1 && (Integer)dataTypes.get(0) == 10;
        List businessTimePeriod = this.departmentRepository.getBusinessTimePeriod(this.depId, this.date);
        List<Pair<Date, Date>> fromToTimePeriods = this.getFromToTimePeriods(businessTimePeriod);
        this.dwellTimeHourlyRepository.deleteByDepIdAndDate(this.depId, this.date);
        ArrayList depIds = Lists.newArrayList((Object[])new Integer[]{this.depId});
        ArrayList tagIds = Lists.newArrayList((Object[])new Integer[]{tagId});
        for (Pair<Date, Date> fromToTimePeriod : fromToTimePeriods) {
            String startTime = DateUtils.formatLongDate((Date)((Date)fromToTimePeriod.getKey()));
            String endTime = DateUtils.formatLongDate((Date)((Date)fromToTimePeriod.getValue()));
            QueryParam queryParam = QueryParam.builder().setBasicParams((List)depIds, (List)tagIds, startTime, endTime).build();
            List details = this.customerFlowDetailRepository.listSecondLevel(queryParam, isOnlyPc8C);
            if (CollectionUtils.isEmpty((Collection)details)) continue;
            List entryExitEvents = EntryExitEventFactory.createEntryExitEvents((List)details);
            List dwellTimeHourlies = DwellTimeHourlyFactory.createDwellTimeHourlies((List)entryExitEvents, (Integer)this.depId, (Date)((Date)fromToTimePeriod.getKey()), (Date)((Date)fromToTimePeriod.getValue()));
            this.dwellTimeHourlyRepository.saveBatch(dwellTimeHourlies);
        }
    }

    private List<Pair<Date, Date>> getFromToTimePeriods(List<BusinessFromToTime> businessTimePeriod) {
        ArrayList<Pair<Date, Date>> fromToTimePeriods = new ArrayList<Pair<Date, Date>>();
        if (this.isValidBusinessTimePeriod(businessTimePeriod)) {
            for (BusinessFromToTime businessFromToTime : businessTimePeriod) {
                Date fromTime = DateUtils.timeStr2Date((String)StringUtils.joinWith((String)"", (Object[])new Object[]{this.date, " ", businessFromToTime.getFromTime(), ":00"}));
                Date toTime = DateUtils.timeStr2Date((String)StringUtils.joinWith((String)"", (Object[])new Object[]{this.date, " ", businessFromToTime.getToTime(), ":59"}));
                fromToTimePeriods.add((Pair<Date, Date>)new Pair((Object)fromTime, (Object)toTime));
            }
        } else {
            Date str2Date = DateUtils.timeStr2Date((String)this.date);
            fromToTimePeriods.add((Pair<Date, Date>)new Pair((Object)DateUtils.getStartTimeOfDay((Date)str2Date), (Object)DateUtils.getEndTimeOfDay((Date)str2Date)));
        }
        return fromToTimePeriods;
    }

    private void verify() {
        if (this.depId == null || this.customerFlowDetailRepository == null || this.departmentRepository == null || this.shopFlowTagRepository == null || this.dwellTimeHourlyRepository == null || this.deviceFlowTagRepository == null || StringUtils.isBlank((CharSequence)this.date)) {
            throw new BizException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
    }

    public boolean isValidBusinessTimePeriod(List<BusinessFromToTime> businessTimePeriod) {
        if (CollectionUtils.isEmpty(businessTimePeriod)) {
            return false;
        }
        for (BusinessFromToTime businessFromToTime : businessTimePeriod) {
            if (this.isValidBusinessDatePattern(businessFromToTime.getFromTime()) && this.isValidBusinessDatePattern(businessFromToTime.getToTime())) continue;
            log.warn("businessTimePeriod is invalid, businessTimePeriod:{}", businessTimePeriod);
            return false;
        }
        return true;
    }

    public boolean isValidBusinessDatePattern(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return false;
        }
        return time.matches("^\\d{2}:\\d{2}$");
    }
}

