/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.dwell.query;

import com.ovopark.passenger.common.QueryParam;
import com.ovopark.passenger.dwell.entity.DwellTimeHourlyRepository;
import com.ovopark.passenger.dwell.valueobject.DwellTimeData;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DwellTimeQueryExecutor {
    private DwellTimeHourlyRepository dwellTimeHourlyRepository;

    public DwellTimeQueryExecutor(DwellTimeHourlyRepository dwellTimeHourlyRepository) {
        this.dwellTimeHourlyRepository = dwellTimeHourlyRepository;
    }

    public DwellTimeData executeQuerySum(QueryParam param) {
        List<DwellTimeData> list = this.executeQuery(param);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return new DwellTimeData();
    }

    public List<DwellTimeData> executeQuery(QueryParam param) {
        this.verifyParam(param);
        return this.dwellTimeHourlyRepository.listDwellTimeData(param);
    }

    private void verifyParam(QueryParam param) {
        if (param == null || this.dwellTimeHourlyRepository == null) {
            throw new BizException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)param.getDepIds()) || StringUtils.isBlank((CharSequence)param.getStartTime()) || StringUtils.isBlank((CharSequence)param.getEndTime())) {
            throw new BizException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
    }
}

