/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.occupancy.qry;

import com.ovopark.passenger.core.entity.DeviceProductArea;
import com.ovopark.passenger.core.entity.DeviceProductAreaRepository;
import com.ovopark.passenger.occupancy.assembler.RegionalCombinationAssembler;
import com.ovopark.passenger.occupancy.dto.OccupancyRegionalCombinationDto;
import com.ovopark.passenger.occupancy.entity.OccupancyCombinationArea;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalCombination;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalCombinationRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class OccupancyRegionalCombinationQryExecutor {
    @Resource
    private OccupancyRegionalCombinationRepository occupancyRegionalCombinationRepository;
    @Resource
    private OccupancyRegionalPlanRepository occupancyRegionalPlanRepository;
    @Resource
    private DeviceProductAreaRepository deviceProductAreaRepository;

    public List<OccupancyRegionalCombinationDto> executeQryByVirtualSpaceId(Integer virtualSpaceId) {
        List occupancyRegionalCombinations = this.occupancyRegionalCombinationRepository.listByVirtualSpaceId(virtualSpaceId);
        if (occupancyRegionalCombinations == null || occupancyRegionalCombinations.isEmpty()) {
            return new ArrayList<OccupancyRegionalCombinationDto>();
        }
        ArrayList<Integer> planIds = new ArrayList<Integer>();
        ArrayList<Integer> productAreaIds = new ArrayList<Integer>();
        for (OccupancyRegionalCombination combination : occupancyRegionalCombinations) {
            List areas = combination.getOccupancyCombinationAreas();
            if (areas == null || areas.isEmpty()) continue;
            for (OccupancyCombinationArea area : areas) {
                if (area.getRegionalPlanId() != null) {
                    planIds.add(area.getRegionalPlanId());
                    continue;
                }
                if (area.getProductAreaId() == null) continue;
                productAreaIds.add(area.getProductAreaId());
            }
        }
        Map planMap = this.occupancyRegionalPlanRepository.listByIds(planIds).stream().filter(p -> p.getIsDel() != null && p.getIsDel() == 0).collect(Collectors.toMap(OccupancyRegionalPlan::getId, Function.identity()));
        Map<Integer, String> productAreaNameMap = this.deviceProductAreaRepository.listValidByAreaIds(productAreaIds).stream().collect(Collectors.toMap(DeviceProductArea::getId, DeviceProductArea::getProductName));
        ArrayList<Integer> removeAreaIds = new ArrayList<Integer>();
        for (OccupancyRegionalCombination combination : occupancyRegionalCombinations) {
            List areas = combination.getOccupancyCombinationAreas();
            if (areas == null || areas.isEmpty()) continue;
            for (int i = areas.size() - 1; i >= 0; --i) {
                OccupancyCombinationArea area = (OccupancyCombinationArea)areas.get(i);
                if (area.getRegionalPlanId() != null) {
                    OccupancyRegionalPlan plan = (OccupancyRegionalPlan)planMap.get(area.getRegionalPlanId());
                    if (plan == null) {
                        removeAreaIds.add(area.getId());
                        areas.remove(i);
                        continue;
                    }
                    area.setRegionalPlanName(plan.getRegionalPlanName());
                    area.setAreaType(OccupancyCombinationArea.AREA_TYPE_SPACE);
                    area.setPeopleNum(plan.getRegulation());
                    continue;
                }
                if (area.getProductAreaId() == null) continue;
                String s = productAreaNameMap.get(area.getProductAreaId());
                if (s == null) {
                    removeAreaIds.add(area.getId());
                    areas.remove(i);
                    continue;
                }
                area.setProductName(s);
                area.setAreaType(OccupancyCombinationArea.AREA_TYPE_PRODUCT);
            }
        }
        if (CollectionUtils.isNotEmpty(removeAreaIds)) {
            this.occupancyRegionalCombinationRepository.removeByCombinationAreaIds(removeAreaIds);
        }
        return occupancyRegionalCombinations.stream().map(RegionalCombinationAssembler::domain2Dto).collect(Collectors.toList());
    }
}

