/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pojo;

import org.slf4j.MDC;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, "20000", "\u65e0\u6548\u7684token");
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, "20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public static <T> BaseResult<T> error(T data, String code, String message) {
        return new BaseResult<T>(true, data, code, message);
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public String toString() {
        return "BaseResult{isError=" + this.isError + ", data=" + this.data + ", code='" + this.code + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public String getRequestId() {
        return MDC.get((String)"TRACE_ID");
    }

    public abstract class CommonMessage {
        public static final String SUCCESS = "\u8bf7\u6c42\u6570\u636e\u6210\u529f!";
        public static final String ERROR = "\u8bf7\u6c42\u6570\u636e\u5931\u8d25";
        public static final String IS_EXIST = "\u8bb0\u5f55\u5df2\u5b58\u5728";
        public static final String INVALID_TOKEN = "\u65e0\u6548\u7684token";
        public static final String PARAM_ERROR = "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef";
        public static final String REPEAT_EXECUTION_ERROR = "\u91cd\u590d\u6267\u884c\u5f02\u5e38";
        public static final String BATCH_UPLOAD_UNDONE_ERROR = "\u6279\u91cf\u4e0a\u4f20\u672a\u5b8c\u6210,\u65e0\u6cd5\u663e\u793a\u5f02\u5e38\u8bb0\u5f55!";
        public static final String NOT_PASSENGER_FLOW_DEVICE_ERROR = "\u975e\u5ba2\u6d41\u8bbe\u5907\u5f02\u5e38";
    }

    public abstract class CommonCode {
        public static final String SUCCESS = "0";
        public static final String ERROR = "1";
        public static final String IS_EXIST = "10000";
        public static final String INVALID_TOKEN = "20000";
        public static final String PARAM_ERROR = "20001";
        public static final String REPEAT_EXECUTION_ERROR = "30000";
        public static final String BATCH_UPLOAD_UNDONE_ERROR = "30001";
        public static final String NOT_PASSENGER_FLOW_DEVICE_ERROR = "30002";
    }
}

