/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common;

import com.ovopark.passenger.common.DeepCopier;
import java.io.Serializable;

public class Aggregate<T extends Serializable> {
    private T snapshot;
    private T root;

    public static <T extends Serializable> Aggregate<T> of(T root) {
        T snapshot = new DeepCopier<T>(){}.deepCopy(root);
        return new Aggregate<T>(snapshot, root);
    }

    public Aggregate<T> refresh(T root) {
        T snapshot = new DeepCopier<T>(){}.deepCopy(root);
        this.root = root;
        this.snapshot = snapshot;
        return this;
    }

    public Aggregate(T snapshot, T root) {
        this.root = root;
        this.snapshot = snapshot;
    }

    public T getSnapshot() {
        return this.snapshot;
    }

    public T getRoot() {
        return this.root;
    }

    public void setRoot(T root) {
        this.root = root;
    }

    public void remove() {
        this.root = null;
    }

    public String toString() {
        return "Aggregate{snapshot=" + this.snapshot + ", root=" + this.root + '}';
    }
}

