/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private T value;
    private List<TreeNode> children;

    public List<T> allLeaves() {
        return this.allLeavesHelper(this);
    }

    public List<T> allLeavesHelper(TreeNode<T> node) {
        if (node == null) {
            return null;
        }
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            ArrayList<T> leaves = new ArrayList<T>();
            leaves.add(node.getValue());
            return leaves;
        }
        List<T> leaves = null;
        for (TreeNode child : node.getChildren()) {
            List<T> childLeaves = this.allLeavesHelper(child);
            if (childLeaves == null) continue;
            if (leaves == null) {
                leaves = childLeaves;
                continue;
            }
            leaves.addAll(childLeaves);
        }
        return leaves;
    }

    public T getValue() {
        return this.value;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public TreeNode<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public TreeNode<T> setChildren(List<TreeNode> children) {
        this.children = children;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<TreeNode> this$children = this.getChildren();
        List<TreeNode> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<TreeNode> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "TreeNode(value=" + this.getValue() + ", children=" + this.getChildren() + ")";
    }
}

