/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.core;

import com.ovopark.passenger.core.TrendTreeNode;
import com.ovopark.passenger.core.valueobject.FlowTrend;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class TrendTreeAggregator {
    public static void aggregate(TrendTreeNode root) {
        TrendTreeAggregator.aggregateHelper(root);
    }

    private static void aggregateHelper(TrendTreeNode node) {
        if (CollectionUtils.isEmpty(node.getChildren())) {
            node.executeAlgorithm();
            return;
        }
        for (TrendTreeNode child : node.getChildren()) {
            TrendTreeAggregator.aggregateHelper(child);
        }
        ArrayList<FlowTrend> flowTrends = node.getFlowTrends() == null ? new ArrayList() : node.getFlowTrends();
        for (TrendTreeNode child : node.getChildren()) {
            if (CollectionUtils.isEmpty(child.getFlowTrends())) continue;
            child.getFlowTrends().forEach(flowTrend -> {
                if (flowTrend == null) {
                    return;
                }
                FlowTrend newFlowTrend = new FlowTrend();
                newFlowTrend.setTime(flowTrend.getTime());
                newFlowTrend.setInCount(flowTrend.getInCount());
                newFlowTrend.setOutCount(flowTrend.getOutCount());
                newFlowTrend.setPassengerFlow(flowTrend.getPassengerFlow());
                Optional<FlowTrend> first = flowTrends.stream().filter(trend -> trend.getTime().equals(newFlowTrend.getTime())).findFirst();
                if (first.isPresent()) {
                    FlowTrend existFlowTrend = first.get();
                    existFlowTrend.setInCount(TrendTreeAggregator.add(existFlowTrend.getInCount(), newFlowTrend.getInCount()));
                    existFlowTrend.setOutCount(TrendTreeAggregator.add(existFlowTrend.getOutCount(), newFlowTrend.getOutCount()));
                } else {
                    flowTrends.add(newFlowTrend);
                }
            });
        }
        node.setFlowTrends(flowTrends);
        node.executeAlgorithm();
    }

    private static Integer add(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a + b;
    }

    public static List<TrendTreeNode> getLeafNodes(TrendTreeNode root) {
        ArrayList<TrendTreeNode> leafNodes = new ArrayList<TrendTreeNode>();
        TrendTreeAggregator.getLeafNodesHelper(root, leafNodes);
        return leafNodes;
    }

    private static void getLeafNodesHelper(TrendTreeNode root, List<TrendTreeNode> leafNodes) {
        if (CollectionUtils.isEmpty(root.getChildren())) {
            leafNodes.add(root);
            return;
        }
        for (TrendTreeNode child : root.getChildren()) {
            TrendTreeAggregator.getLeafNodesHelper(child, leafNodes);
        }
    }
}

