/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.core;

import com.ovopark.passenger.common.enums.FlowCountAlgorithmEnum;
import com.ovopark.passenger.core.valueobject.FlowTrend;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class TrendTreeNode {
    private String id;
    private String name;
    private String mac;
    private List<FlowTrend> flowTrends;
    private Enum algorithm;
    private List<TrendTreeNode> children;

    public void executeAlgorithm() {
        block7: {
            block8: {
                block6: {
                    if (this.algorithm == null || CollectionUtils.isEmpty(this.flowTrends)) {
                        return;
                    }
                    if (!this.algorithm.equals((Object)FlowCountAlgorithmEnum.SUM)) break block6;
                    for (FlowTrend flowTrend : this.flowTrends) {
                        if (flowTrend == null) continue;
                        Integer inCount = flowTrend.getInCount();
                        Integer outCount = flowTrend.getOutCount();
                        Integer passengerFlow = null;
                        if (inCount != null) {
                            passengerFlow = inCount;
                        }
                        if (outCount != null) {
                            passengerFlow = passengerFlow == null ? outCount : passengerFlow + outCount;
                        }
                        flowTrend.setPassengerFlow(passengerFlow);
                    }
                    break block7;
                }
                if (!this.algorithm.equals((Object)FlowCountAlgorithmEnum.IN)) break block8;
                for (FlowTrend flowTrend : this.flowTrends) {
                    if (flowTrend == null) continue;
                    flowTrend.setPassengerFlow(flowTrend.getInCount());
                }
                break block7;
            }
            if (!this.algorithm.equals((Object)FlowCountAlgorithmEnum.OUT)) break block7;
            for (FlowTrend flowTrend : this.flowTrends) {
                if (flowTrend == null) continue;
                flowTrend.setPassengerFlow(flowTrend.getOutCount());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMac() {
        return this.mac;
    }

    public List<FlowTrend> getFlowTrends() {
        return this.flowTrends;
    }

    public Enum getAlgorithm() {
        return this.algorithm;
    }

    public List<TrendTreeNode> getChildren() {
        return this.children;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setFlowTrends(List<FlowTrend> flowTrends) {
        this.flowTrends = flowTrends;
    }

    public void setAlgorithm(Enum algorithm) {
        this.algorithm = algorithm;
    }

    public void setChildren(List<TrendTreeNode> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrendTreeNode)) {
            return false;
        }
        TrendTreeNode other = (TrendTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<FlowTrend> this$flowTrends = this.getFlowTrends();
        List<FlowTrend> other$flowTrends = other.getFlowTrends();
        if (this$flowTrends == null ? other$flowTrends != null : !((Object)this$flowTrends).equals(other$flowTrends)) {
            return false;
        }
        Enum this$algorithm = this.getAlgorithm();
        Enum other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        List<TrendTreeNode> this$children = this.getChildren();
        List<TrendTreeNode> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrendTreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<FlowTrend> $flowTrends = this.getFlowTrends();
        result = result * 59 + ($flowTrends == null ? 43 : ((Object)$flowTrends).hashCode());
        Enum $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        List<TrendTreeNode> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "TrendTreeNode(id=" + this.getId() + ", name=" + this.getName() + ", mac=" + this.getMac() + ", flowTrends=" + this.getFlowTrends() + ", algorithm=" + this.getAlgorithm() + ", children=" + this.getChildren() + ")";
    }
}

