/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.core.valueobject;

import com.ovopark.passenger.common.constant.FlowDeviceConstant;
import com.ovopark.passenger.common.util.PassengerDeviceUtils;
import com.ovopark.passenger.core.entity.DeviceGroup;
import com.ovopark.passenger.core.entity.DeviceGroupRepository;
import com.ovopark.passenger.core.entity.DeviceProductArea;
import com.ovopark.passenger.core.entity.DeviceProductAreaRepository;
import com.ovopark.passenger.core.entity.GroupDevice;
import com.ovopark.passenger.core.valueobject.ShopConfigItem;
import com.ovopark.passenger.support.DeviceRepository;
import com.ovopark.passenger.support.DeviceStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ShopConfigItemService {
    private final DeviceRepository deviceRepository;
    private final DeviceProductAreaRepository deviceProductAreaRepository;
    private final DeviceGroupRepository deviceGroupRepository;

    public ShopConfigItemService(DeviceRepository deviceRepository, DeviceProductAreaRepository deviceProductAreaRepository, DeviceGroupRepository deviceGroupRepository) {
        this.deviceRepository = deviceRepository;
        this.deviceProductAreaRepository = deviceProductAreaRepository;
        this.deviceGroupRepository = deviceGroupRepository;
    }

    public List<ShopConfigItem> getShopConfigItemDictionaryByDepId(Integer depId) {
        List<DeviceGroup> deviceGroups = this.deviceGroupRepository.listByDepId(depId);
        List groupDeviceIds = deviceGroups.stream().flatMap(group -> group.getDevices().stream()).map(GroupDevice::getDeviceId).collect(Collectors.toList());
        List<DeviceStatus> devices = this.deviceRepository.listPassengerDeviceByDepId(depId);
        ArrayList<DeviceStatus> productAreaDevices = new ArrayList<DeviceStatus>();
        ArrayList<DeviceStatus> singleDevices = new ArrayList<DeviceStatus>();
        for (DeviceStatus device2 : devices) {
            if (Optional.ofNullable(PassengerDeviceUtils.getDataType(device2.getDType(), device2.getExtendCapacity(), device2.getDeviceType())).map(d -> d == 10).orElse(false).booleanValue()) {
                productAreaDevices.add(device2);
                continue;
            }
            if (groupDeviceIds.contains(device2.getId())) continue;
            singleDevices.add(device2);
        }
        List<ShopConfigItem> res = this.getShopConfigItemDictionaryBySingleDevices(singleDevices);
        List<Integer> productAreaDeviceIds = productAreaDevices.stream().map(DeviceStatus::getId).collect(Collectors.toList());
        Map<Integer, List<DeviceProductArea>> deviceIdAreaMap = this.deviceProductAreaRepository.listProductAreaByDeviceIds(productAreaDeviceIds).stream().collect(Collectors.groupingBy(DeviceProductArea::getDeviceId));
        productAreaDevices.forEach(device -> device.setDeviceProductAreas((List)deviceIdAreaMap.get(device.getId())));
        String pc8cDeviceType = FlowDeviceConstant.getDeviceType(10);
        res.stream().filter(item -> item.getDeviceType().equals(pc8cDeviceType)).findFirst().ifPresent(item -> item.setProductAreaDevices(productAreaDevices));
        String reidDeviceType = FlowDeviceConstant.getDeviceType(12);
        res.stream().filter(item -> item.getDeviceType().equals(reidDeviceType)).findFirst().ifPresent(item -> item.setDeviceGroups(deviceGroups));
        return res;
    }

    private List<ShopConfigItem> getShopConfigItemDictionaryBySingleDevices(List<DeviceStatus> devices) {
        ArrayList<ShopConfigItem> res = new ArrayList<ShopConfigItem>();
        FlowDeviceConstant.getDeviceDictionary().forEach(flowDeviceVo -> {
            ShopConfigItem item = new ShopConfigItem();
            item.setDeviceType(flowDeviceVo.getDeviceType());
            item.setDevices(new ArrayList<DeviceStatus>());
            if (devices != null) {
                for (DeviceStatus device : devices) {
                    if (!flowDeviceVo.getDataType().equals(PassengerDeviceUtils.getDataType(device.getDType(), device.getExtendCapacity(), device.getDeviceType()))) continue;
                    item.getDevices().add(device);
                }
            }
            res.add(item);
        });
        return res;
    }
}

