/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common.constant;

import com.ovopark.passenger.core.valueobject.FlowDeviceConfigItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FlowDeviceConstant
implements Serializable {
    private static final long serialVersionUID = 1785904112840791703L;
    public static final String VIRTUAL_DEVICE_MAC = "gggggggggggg";
    public static volatile List<FlowDeviceConfigItem> deviceDictionary = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<FlowDeviceConfigItem> getDeviceDictionary() {
        if (deviceDictionary != null) return deviceDictionary;
        Class<FlowDeviceConstant> clazz = FlowDeviceConstant.class;
        synchronized (FlowDeviceConstant.class) {
            if (deviceDictionary != null) return deviceDictionary;
            FlowDeviceConstant.initData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return deviceDictionary;
        }
    }

    private static void initData() {
        deviceDictionary = new ArrayList<FlowDeviceConfigItem>();
        deviceDictionary.add(new FlowDeviceConfigItem("PC4", 7, 0));
        deviceDictionary.add(new FlowDeviceConfigItem("FR3", 11, 2));
        deviceDictionary.add(new FlowDeviceConfigItem("PC6-W", 29, 4));
        deviceDictionary.add(new FlowDeviceConfigItem("PC5", 27, 5));
        deviceDictionary.add(new FlowDeviceConfigItem("FR4", 31, 6));
        deviceDictionary.add(new FlowDeviceConfigItem("PC8-A", 52, 7));
        deviceDictionary.add(new FlowDeviceConfigItem("PC-R1", 53, 8));
        deviceDictionary.add(new FlowDeviceConfigItem("IPC", 21, 9));
        deviceDictionary.add(new FlowDeviceConfigItem("PC8-C", 52, 10));
        deviceDictionary.add(new FlowDeviceConfigItem("PC6_D1", 114, 11));
        deviceDictionary.add(new FlowDeviceConfigItem("REID", 20, 12));
    }

    public static String getDeviceType(Integer dataType) {
        if (dataType == null) {
            return null;
        }
        List<FlowDeviceConfigItem> deviceDictionary = FlowDeviceConstant.getDeviceDictionary();
        String deviceType = null;
        for (FlowDeviceConfigItem vo : deviceDictionary) {
            if (!vo.getDataType().equals(dataType)) continue;
            deviceType = vo.getDeviceType();
            break;
        }
        return deviceType;
    }
}

