/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common.util;

import java.math.BigDecimal;

public class NumberUtils {
    public static Integer getSubtract(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return a - b;
    }

    public static Integer getOrDefault(Integer a) {
        return a == null ? 0 : a;
    }

    public static BigDecimal getDivide(Number a, Number b, int scale) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal bDecimal = new BigDecimal(b.toString());
        if (bDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(a.toString()).divide(bDecimal, scale, 4);
    }

    public static BigDecimal calculateRate(Number data, Number divisor, Integer n, boolean isDivided0ReturnNull) {
        if (data == null || divisor == null) {
            return null;
        }
        BigDecimal d = new BigDecimal(divisor.toString());
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            if (isDivided0ReturnNull) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        BigDecimal rate = new BigDecimal(data.toString()).multiply(new BigDecimal("100")).divide(d, (int)n, 4);
        return rate;
    }

    public static BigDecimal keep2Decimal(Double d) {
        if (d == null) {
            return null;
        }
        if (d == 0.0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bd = new BigDecimal(d.toString()).setScale(2, 4);
        return bd;
    }
}

