/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.dwell.entity;

import com.ovopark.passenger.common.util.DateUtils;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.dwell.entity.DwellTimeHourly;
import com.ovopark.passenger.dwell.valueobject.EntryExitEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class DwellTimeHourlyFactory {
    public static List<DwellTimeHourly> createDwellTimeHourlies(List<EntryExitEvent> events, Integer depId, Date startTime, Date endTime) {
        ArrayList<DwellTimeHourly> res = new ArrayList<DwellTimeHourly>();
        if (CollectionUtils.isEmpty(events)) {
            return res;
        }
        Date hourDate = null;
        int paxInStore = 0;
        DwellTimeHourly dwellTimeHourly = null;
        for (int i = 0; i < events.size(); ++i) {
            EntryExitEvent event = events.get(i);
            Date thisHourDate = DateUtils.getHourDate(event.getTime());
            if (i == 0) {
                hourDate = thisHourDate;
                dwellTimeHourly = new DwellTimeHourly(depId, thisHourDate, 0L, 0, event.getEntryCount(), event.getExitCount(), startTime, endTime);
                paxInStore = DwellTimeHourlyFactory.negative2Zero(event.getEntryCount() - event.getExitCount());
                continue;
            }
            if (thisHourDate.equals(hourDate)) {
                if (paxInStore > 0) {
                    dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(events.get(i - 1).getTime(), event.getTime()) * (long)paxInStore);
                }
                paxInStore = DwellTimeHourlyFactory.negative2Zero(paxInStore + event.getEntryCount() - event.getExitCount());
                dwellTimeHourly.setInCount(dwellTimeHourly.getInCount() + event.getEntryCount());
                dwellTimeHourly.setOutCount(dwellTimeHourly.getOutCount() + event.getExitCount());
            } else {
                List<Date> intervalHourDates = DateUtils.getIntervalHourDates(hourDate, thisHourDate);
                if (CollectionUtils.isEmpty(intervalHourDates)) {
                    if (paxInStore > 0) {
                        dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(events.get(i - 1).getTime(), thisHourDate) * (long)paxInStore);
                    }
                    DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
                } else {
                    if (paxInStore > 0) {
                        dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(events.get(i - 1).getTime(), intervalHourDates.get(0)) * (long)paxInStore);
                    }
                    DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
                    for (Date date : intervalHourDates) {
                        dwellTimeHourly = new DwellTimeHourly(depId, date, 3600L * (long)paxInStore, paxInStore, 0, 0, startTime, endTime);
                        DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
                    }
                }
                dwellTimeHourly = new DwellTimeHourly(depId, thisHourDate, 0L, paxInStore, event.getEntryCount(), event.getExitCount(), startTime, endTime);
                if (paxInStore > 0) {
                    dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(thisHourDate, event.getTime()) * (long)paxInStore);
                }
                paxInStore = DwellTimeHourlyFactory.negative2Zero(paxInStore + event.getEntryCount() - event.getExitCount());
                hourDate = thisHourDate;
            }
            if (i != events.size() - 1) continue;
            Date end = DateUtils.addSeconds(endTime, 1);
            List<Date> intervalHourDates = DateUtils.getIntervalHourDates(hourDate, end);
            if (CollectionUtils.isEmpty(intervalHourDates)) {
                if (paxInStore > 0) {
                    dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(event.getTime(), end) * (long)paxInStore);
                }
                DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
                continue;
            }
            if (paxInStore > 0) {
                dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(event.getTime(), intervalHourDates.get(0)) * (long)paxInStore);
            }
            DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
            for (int j = 0; j < intervalHourDates.size() - 1; ++j) {
                Date date = intervalHourDates.get(j);
                if (j == intervalHourDates.size() - 1) {
                    dwellTimeHourly = new DwellTimeHourly(depId, date, 0L, paxInStore, 0, 0, startTime, endTime);
                    if (paxInStore > 0) {
                        dwellTimeHourly.setSumDwellTime(dwellTimeHourly.getSumDwellTime() + DateUtils.getIntervalSeconds(date, end) * (long)paxInStore);
                    }
                } else {
                    dwellTimeHourly = new DwellTimeHourly(depId, date, 3600L * (long)paxInStore, paxInStore, 0, 0, startTime, endTime);
                }
                DwellTimeHourlyFactory.addDwellTimeHourly(res, dwellTimeHourly);
            }
        }
        res.stream().forEach(hourly -> {
            hourly.setSumPaxInStore(hourly.getStartPaxInStore() + hourly.getInCount());
            hourly.setAvgDwellTime(NumberUtils.getDivide(hourly.getSumDwellTime(), hourly.getSumPaxInStore(), 0).intValue());
        });
        return res;
    }

    private static void addDwellTimeHourly(List<DwellTimeHourly> res, DwellTimeHourly dwellTimeHourly) {
        if (dwellTimeHourly.getInCount() == 0 && dwellTimeHourly.getOutCount() == 0 && dwellTimeHourly.getSumDwellTime() == 0L && dwellTimeHourly.getStartPaxInStore() == 0) {
            return;
        }
        res.add(dwellTimeHourly);
    }

    private static int negative2Zero(int num) {
        return num < 0 ? 0 : num;
    }
}

