/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.ck.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ovopark.passenger.ck.model.TelemetryModel;
import com.ovopark.passenger.pojo.TelemetryRow;
import com.ovopark.passenger.pojo.vo.DressTypeDetailVo;
import java.sql.Timestamp;
import java.util.List;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;

@Mapper
public interface TelemetryCkMapper
extends BaseMapper<TelemetryModel> {
    @Select(value={"SELECT enterprise_id, dep_id, flow_id, device_id, mac,", "       record_time, in_count1, out_count1,", "       stay_time, leave_time, version", "FROM passenger_flow_telemetry", "WHERE enterprise_id = #{enterpriseId}", "  AND dep_id       = #{depId}", "  AND record_time >= #{start}", "  AND record_time <  #{end}", "ORDER BY record_time", "LIMIT #{limit}"})
    public List<TelemetryRow> listRange(@Param(value="enterpriseId") int var1, @Param(value="depId") int var2, @Param(value="start") Timestamp var3, @Param(value="end") Timestamp var4, @Param(value="limit") int var5);

    @Select(value={"SELECT enterprise_id, dep_id, flow_id, device_id, mac,", "       record_time, in_count1, out_count1,", "       stay_time, leave_time, version", "FROM passenger_flow_telemetry FINAL", "WHERE flow_id = #{flowId}", "ORDER BY record_time"})
    public List<TelemetryRow> findByFlowId(@Param(value="flowId") String var1);

    @Select(value={"SELECT 1"})
    public Integer ping();

    @Lang(value=XMLLanguageDriver.class)
    @Select(value={"<script>", "SELECT", "  argMax(t.enterprise_id, t.version) AS enterpriseId,", "  argMax(t.dep_id,        t.version) AS depId,", "  t.flow_id                           AS flowId,", "  argMax(t.device_id,     t.version) AS deviceId,", "  argMax(t.mac,           t.version) AS mac,", "  argMax(t.record_time,   t.version) AS recordTime,", "  argMax(t.in_count1,     t.version) AS inCount1,", "  argMax(t.out_count1,    t.version) AS outCount1,", "  argMax(t.stay_time,     t.version) AS stayTime,", "  argMax(t.leave_time,    t.version) AS leaveTime,", "  argMax(t.is_valid,    t.version) AS isValid,", "  argMax(t.gender,    t.version) AS gender,", "  argMax(t.batch_num,    t.version) AS batchNum,", "  argMax(t.batch_relation,    t.version) AS batchRelation,", "  argMax(t.age,    t.version) AS age,", "  argMax(t.face_id,    t.version) AS faceId,", "  argMax(t.tag_id,    t.version) AS tagId,", "  argMax(t.product_id,    t.version) AS productId,", "  argMax(t.tag_type,    t.version) AS tagType,", "  argMax(t.is_on_business_time,    t.version) AS isOnBusinessTime,", "  max(t.version)                      AS maxVersion", "FROM passenger_flow_telemetry t", "PREWHERE 1=1", "  <if test='enterpriseId != null'> AND t.enterprise_id = #{enterpriseId} </if>", "  <if test='start != null and end != null'>", "     AND t.record_time BETWEEN toDateTime64(#{start}, 3) AND toDateTime64(#{end},   3)", "  </if>", "  <if test='depId != null'> AND t.dep_id = #{depId} </if>", "  <if test='start != null'> AND t.record_hour <![CDATA[>=]]> toStartOfHour(toDateTime64(#{start}, 3)) </if>", "  <if test='end != null'>   AND t.record_hour <![CDATA[<=]]> toStartOfHour(toDateTime64(#{end},   3))   </if>", "<where>", "  <if test='macs != null and macs.size() > 0'>", "    AND t.mac IN", "    <foreach collection='macs' item='m' open='(' separator=',' close=')'>", "      #{m}", "    </foreach>", "  </if>", "  <if test='tagIds != null and tagIds.size() > 0'>", "    AND t.tag_id IN", "    <foreach collection='tagIds' item='t' open='(' separator=',' close=')'>", "      #{t}", "    </foreach>", "  </if>", "  <if test='faceIds != null and faceIds.size() > 0'>", "    AND t.face_id IN", "    <foreach collection='faceIds' item='f' open='(' separator=',' close=')'>", "      #{f}", "    </foreach>", "  </if>", "  AND t.is_valid = 1", "  AND t.in_count1 <![CDATA[>]]> 0", "</where>", "GROUP BY t.flow_id", "ORDER BY recordTime", "</script>"})
    @Results(value={@Result(column="maxVersion", property="version")})
    public List<TelemetryRow> findCorrectsLatest(@Param(value="enterpriseId") Integer var1, @Param(value="depId") Integer var2, @Param(value="start") Timestamp var3, @Param(value="end") Timestamp var4, @Param(value="macs") List<String> var5, @Param(value="tagIds") List<Integer> var6, @Param(value="faceIds") List<String> var7);

    public boolean batchInsert(@Param(value="valueList") String var1);

    public List<DressTypeDetailVo> getTypeCategoriesByTops(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByLowers(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByAccessories(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByShoes(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByStyle(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByTopsColor(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);

    public List<DressTypeDetailVo> getTypeCategoriesByLowersColor(@Param(value="type") String var1, @Param(value="enterpriseId") Integer var2, @Param(value="depIds") List<Integer> var3, @Param(value="startTime") String var4, @Param(value="endTime") String var5, @Param(value="timeType") Integer var6, @Param(value="startHour") Integer var7, @Param(value="endHour") Integer var8, @Param(value="isOnBusinessTime") Integer var9);
}

